/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot;

import java.util.stream.Stream;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.SearchTypeHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.HasAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivot;

public abstract class ESPivotBucketSpecHandler<SPEC_TYPE extends BucketSpec, AGGREGATION_RESULT extends Aggregation>
implements BucketSpecHandler<SPEC_TYPE, AggregationBuilder, SearchResponse, AGGREGATION_RESULT, ESPivot, ESGeneratedQueryContext> {
    protected ESPivot.AggTypes aggTypes(ESGeneratedQueryContext queryContext, Pivot pivot) {
        return (ESPivot.AggTypes)queryContext.contextMap().get(pivot.id());
    }

    protected void record(ESGeneratedQueryContext queryContext, Pivot pivot, PivotSpec spec, String name, Class<? extends Aggregation> aggregationClass) {
        this.aggTypes(queryContext, pivot).record(spec, name, aggregationClass);
    }

    protected Aggregation extractAggregationFromResult(Pivot pivot, PivotSpec spec, HasAggregations aggregations, ESGeneratedQueryContext queryContext) {
        return this.aggTypes(queryContext, pivot).getSubAggregation(spec, aggregations);
    }

    public Stream<Bucket> handleResult(Pivot pivot, BucketSpec bucketSpec, Object queryResult, Object aggregationResult, SearchTypeHandler searchTypeHandler, GeneratedQueryContext queryContext) {
        return this.doHandleResult(pivot, bucketSpec, (SearchResponse)queryResult, (Aggregation)aggregationResult, (ESPivot)searchTypeHandler, (ESGeneratedQueryContext)queryContext);
    }

    public abstract Stream<Bucket> doHandleResult(Pivot var1, SPEC_TYPE var2, SearchResponse var3, AGGREGATION_RESULT var4, ESPivot var5, ESGeneratedQueryContext var6);

    public static class Bucket {
        private final String key;
        private final MultiBucketsAggregation.Bucket bucket;

        public Bucket(String key, MultiBucketsAggregation.Bucket bucket) {
            this.key = key;
            this.bucket = bucket;
        }

        public static Bucket create(String key, MultiBucketsAggregation.Bucket aggregation) {
            return new Bucket(key, aggregation);
        }

        public String key() {
            return this.key;
        }

        public MultiBucketsAggregation.Bucket aggregation() {
            return this.bucket;
        }
    }
}

