/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateDhcpOptionsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateDhcpOptionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateDhcpOptionsRequest> {
    private SdkInternalList<DhcpConfiguration> dhcpConfigurations;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public CreateDhcpOptionsRequest() {
    }

    public CreateDhcpOptionsRequest(List<DhcpConfiguration> dhcpConfigurations) {
        this.setDhcpConfigurations(dhcpConfigurations);
    }

    public List<DhcpConfiguration> getDhcpConfigurations() {
        if (this.dhcpConfigurations == null) {
            this.dhcpConfigurations = new SdkInternalList();
        }
        return this.dhcpConfigurations;
    }

    public void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        if (dhcpConfigurations == null) {
            this.dhcpConfigurations = null;
            return;
        }
        this.dhcpConfigurations = new SdkInternalList<DhcpConfiguration>(dhcpConfigurations);
    }

    public CreateDhcpOptionsRequest withDhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
        if (this.dhcpConfigurations == null) {
            this.setDhcpConfigurations(new SdkInternalList<DhcpConfiguration>(dhcpConfigurations.length));
        }
        for (DhcpConfiguration ele : dhcpConfigurations) {
            this.dhcpConfigurations.add(ele);
        }
        return this;
    }

    public CreateDhcpOptionsRequest withDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        this.setDhcpConfigurations(dhcpConfigurations);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateDhcpOptionsRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateDhcpOptionsRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateDhcpOptionsRequest> getDryRunRequest() {
        Request<CreateDhcpOptionsRequest> request = new CreateDhcpOptionsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: ").append(this.getDhcpConfigurations()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest)obj;
        if (other.getDhcpConfigurations() == null ^ this.getDhcpConfigurations() == null) {
            return false;
        }
        if (other.getDhcpConfigurations() != null && !other.getDhcpConfigurations().equals(this.getDhcpConfigurations())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDhcpConfigurations() == null ? 0 : this.getDhcpConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CreateDhcpOptionsRequest clone() {
        return (CreateDhcpOptionsRequest)super.clone();
    }
}

