/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateVpcEndpointServiceConfigurationRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateVpcEndpointServiceConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateVpcEndpointServiceConfigurationRequest> {
    private Boolean acceptanceRequired;
    private String privateDnsName;
    private SdkInternalList<String> networkLoadBalancerArns;
    private SdkInternalList<String> gatewayLoadBalancerArns;
    private String clientToken;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setAcceptanceRequired(Boolean acceptanceRequired) {
        this.acceptanceRequired = acceptanceRequired;
    }

    public Boolean getAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public CreateVpcEndpointServiceConfigurationRequest withAcceptanceRequired(Boolean acceptanceRequired) {
        this.setAcceptanceRequired(acceptanceRequired);
        return this;
    }

    public Boolean isAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public CreateVpcEndpointServiceConfigurationRequest withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public List<String> getNetworkLoadBalancerArns() {
        if (this.networkLoadBalancerArns == null) {
            this.networkLoadBalancerArns = new SdkInternalList();
        }
        return this.networkLoadBalancerArns;
    }

    public void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
        if (networkLoadBalancerArns == null) {
            this.networkLoadBalancerArns = null;
            return;
        }
        this.networkLoadBalancerArns = new SdkInternalList<String>(networkLoadBalancerArns);
    }

    public CreateVpcEndpointServiceConfigurationRequest withNetworkLoadBalancerArns(String ... networkLoadBalancerArns) {
        if (this.networkLoadBalancerArns == null) {
            this.setNetworkLoadBalancerArns(new SdkInternalList<String>(networkLoadBalancerArns.length));
        }
        for (String ele : networkLoadBalancerArns) {
            this.networkLoadBalancerArns.add(ele);
        }
        return this;
    }

    public CreateVpcEndpointServiceConfigurationRequest withNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
        this.setNetworkLoadBalancerArns(networkLoadBalancerArns);
        return this;
    }

    public List<String> getGatewayLoadBalancerArns() {
        if (this.gatewayLoadBalancerArns == null) {
            this.gatewayLoadBalancerArns = new SdkInternalList();
        }
        return this.gatewayLoadBalancerArns;
    }

    public void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
        if (gatewayLoadBalancerArns == null) {
            this.gatewayLoadBalancerArns = null;
            return;
        }
        this.gatewayLoadBalancerArns = new SdkInternalList<String>(gatewayLoadBalancerArns);
    }

    public CreateVpcEndpointServiceConfigurationRequest withGatewayLoadBalancerArns(String ... gatewayLoadBalancerArns) {
        if (this.gatewayLoadBalancerArns == null) {
            this.setGatewayLoadBalancerArns(new SdkInternalList<String>(gatewayLoadBalancerArns.length));
        }
        for (String ele : gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns.add(ele);
        }
        return this;
    }

    public CreateVpcEndpointServiceConfigurationRequest withGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
        this.setGatewayLoadBalancerArns(gatewayLoadBalancerArns);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateVpcEndpointServiceConfigurationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateVpcEndpointServiceConfigurationRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateVpcEndpointServiceConfigurationRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateVpcEndpointServiceConfigurationRequest> getDryRunRequest() {
        Request<CreateVpcEndpointServiceConfigurationRequest> request = new CreateVpcEndpointServiceConfigurationRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceptanceRequired() != null) {
            sb.append("AcceptanceRequired: ").append(this.getAcceptanceRequired()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName()).append(",");
        }
        if (this.getNetworkLoadBalancerArns() != null) {
            sb.append("NetworkLoadBalancerArns: ").append(this.getNetworkLoadBalancerArns()).append(",");
        }
        if (this.getGatewayLoadBalancerArns() != null) {
            sb.append("GatewayLoadBalancerArns: ").append(this.getGatewayLoadBalancerArns()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationRequest other = (CreateVpcEndpointServiceConfigurationRequest)obj;
        if (other.getAcceptanceRequired() == null ^ this.getAcceptanceRequired() == null) {
            return false;
        }
        if (other.getAcceptanceRequired() != null && !other.getAcceptanceRequired().equals(this.getAcceptanceRequired())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getNetworkLoadBalancerArns() == null ^ this.getNetworkLoadBalancerArns() == null) {
            return false;
        }
        if (other.getNetworkLoadBalancerArns() != null && !other.getNetworkLoadBalancerArns().equals(this.getNetworkLoadBalancerArns())) {
            return false;
        }
        if (other.getGatewayLoadBalancerArns() == null ^ this.getGatewayLoadBalancerArns() == null) {
            return false;
        }
        if (other.getGatewayLoadBalancerArns() != null && !other.getGatewayLoadBalancerArns().equals(this.getGatewayLoadBalancerArns())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceptanceRequired() == null ? 0 : this.getAcceptanceRequired().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkLoadBalancerArns() == null ? 0 : this.getNetworkLoadBalancerArns().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayLoadBalancerArns() == null ? 0 : this.getGatewayLoadBalancerArns().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CreateVpcEndpointServiceConfigurationRequest clone() {
        return (CreateVpcEndpointServiceConfigurationRequest)super.clone();
    }
}

