/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFleetError;
import com.amazonaws.services.ec2.model.DescribeFleetsInstances;
import com.amazonaws.services.ec2.model.FleetActivityStatus;
import com.amazonaws.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfig;
import com.amazonaws.services.ec2.model.FleetStateCode;
import com.amazonaws.services.ec2.model.FleetType;
import com.amazonaws.services.ec2.model.OnDemandOptions;
import com.amazonaws.services.ec2.model.SpotOptions;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TargetCapacitySpecification;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FleetData
implements Serializable,
Cloneable {
    private String activityStatus;
    private Date createTime;
    private String fleetId;
    private String fleetState;
    private String clientToken;
    private String excessCapacityTerminationPolicy;
    private Double fulfilledCapacity;
    private Double fulfilledOnDemandCapacity;
    private SdkInternalList<FleetLaunchTemplateConfig> launchTemplateConfigs;
    private TargetCapacitySpecification targetCapacitySpecification;
    private Boolean terminateInstancesWithExpiration;
    private String type;
    private Date validFrom;
    private Date validUntil;
    private Boolean replaceUnhealthyInstances;
    private SpotOptions spotOptions;
    private OnDemandOptions onDemandOptions;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<DescribeFleetError> errors;
    private SdkInternalList<DescribeFleetsInstances> instances;

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getActivityStatus() {
        return this.activityStatus;
    }

    public FleetData withActivityStatus(String activityStatus) {
        this.setActivityStatus(activityStatus);
        return this;
    }

    public FleetData withActivityStatus(FleetActivityStatus activityStatus) {
        this.activityStatus = activityStatus.toString();
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public FleetData withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setFleetId(String fleetId) {
        this.fleetId = fleetId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public FleetData withFleetId(String fleetId) {
        this.setFleetId(fleetId);
        return this;
    }

    public void setFleetState(String fleetState) {
        this.fleetState = fleetState;
    }

    public String getFleetState() {
        return this.fleetState;
    }

    public FleetData withFleetState(String fleetState) {
        this.setFleetState(fleetState);
        return this;
    }

    public FleetData withFleetState(FleetStateCode fleetState) {
        this.fleetState = fleetState.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public FleetData withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
    }

    public String getExcessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public FleetData withExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.setExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
        return this;
    }

    public FleetData withExcessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
        return this;
    }

    public void setFulfilledCapacity(Double fulfilledCapacity) {
        this.fulfilledCapacity = fulfilledCapacity;
    }

    public Double getFulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public FleetData withFulfilledCapacity(Double fulfilledCapacity) {
        this.setFulfilledCapacity(fulfilledCapacity);
        return this;
    }

    public void setFulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
        this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
    }

    public Double getFulfilledOnDemandCapacity() {
        return this.fulfilledOnDemandCapacity;
    }

    public FleetData withFulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
        this.setFulfilledOnDemandCapacity(fulfilledOnDemandCapacity);
        return this;
    }

    public List<FleetLaunchTemplateConfig> getLaunchTemplateConfigs() {
        if (this.launchTemplateConfigs == null) {
            this.launchTemplateConfigs = new SdkInternalList();
        }
        return this.launchTemplateConfigs;
    }

    public void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfig> launchTemplateConfigs) {
        if (launchTemplateConfigs == null) {
            this.launchTemplateConfigs = null;
            return;
        }
        this.launchTemplateConfigs = new SdkInternalList<FleetLaunchTemplateConfig>(launchTemplateConfigs);
    }

    public FleetData withLaunchTemplateConfigs(FleetLaunchTemplateConfig ... launchTemplateConfigs) {
        if (this.launchTemplateConfigs == null) {
            this.setLaunchTemplateConfigs(new SdkInternalList<FleetLaunchTemplateConfig>(launchTemplateConfigs.length));
        }
        for (FleetLaunchTemplateConfig ele : launchTemplateConfigs) {
            this.launchTemplateConfigs.add(ele);
        }
        return this;
    }

    public FleetData withLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfig> launchTemplateConfigs) {
        this.setLaunchTemplateConfigs(launchTemplateConfigs);
        return this;
    }

    public void setTargetCapacitySpecification(TargetCapacitySpecification targetCapacitySpecification) {
        this.targetCapacitySpecification = targetCapacitySpecification;
    }

    public TargetCapacitySpecification getTargetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public FleetData withTargetCapacitySpecification(TargetCapacitySpecification targetCapacitySpecification) {
        this.setTargetCapacitySpecification(targetCapacitySpecification);
        return this;
    }

    public void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
    }

    public Boolean getTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public FleetData withTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.setTerminateInstancesWithExpiration(terminateInstancesWithExpiration);
        return this;
    }

    public Boolean isTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public FleetData withType(String type) {
        this.setType(type);
        return this;
    }

    public FleetData withType(FleetType type) {
        this.type = type.toString();
        return this;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public FleetData withValidFrom(Date validFrom) {
        this.setValidFrom(validFrom);
        return this;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public FleetData withValidUntil(Date validUntil) {
        this.setValidUntil(validUntil);
        return this;
    }

    public void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
        this.replaceUnhealthyInstances = replaceUnhealthyInstances;
    }

    public Boolean getReplaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public FleetData withReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
        this.setReplaceUnhealthyInstances(replaceUnhealthyInstances);
        return this;
    }

    public Boolean isReplaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public void setSpotOptions(SpotOptions spotOptions) {
        this.spotOptions = spotOptions;
    }

    public SpotOptions getSpotOptions() {
        return this.spotOptions;
    }

    public FleetData withSpotOptions(SpotOptions spotOptions) {
        this.setSpotOptions(spotOptions);
        return this;
    }

    public void setOnDemandOptions(OnDemandOptions onDemandOptions) {
        this.onDemandOptions = onDemandOptions;
    }

    public OnDemandOptions getOnDemandOptions() {
        return this.onDemandOptions;
    }

    public FleetData withOnDemandOptions(OnDemandOptions onDemandOptions) {
        this.setOnDemandOptions(onDemandOptions);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public FleetData withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public FleetData withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<DescribeFleetError> getErrors() {
        if (this.errors == null) {
            this.errors = new SdkInternalList();
        }
        return this.errors;
    }

    public void setErrors(Collection<DescribeFleetError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new SdkInternalList<DescribeFleetError>(errors);
    }

    public FleetData withErrors(DescribeFleetError ... errors) {
        if (this.errors == null) {
            this.setErrors(new SdkInternalList<DescribeFleetError>(errors.length));
        }
        for (DescribeFleetError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public FleetData withErrors(Collection<DescribeFleetError> errors) {
        this.setErrors(errors);
        return this;
    }

    public List<DescribeFleetsInstances> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<DescribeFleetsInstances> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList<DescribeFleetsInstances>(instances);
    }

    public FleetData withInstances(DescribeFleetsInstances ... instances) {
        if (this.instances == null) {
            this.setInstances(new SdkInternalList<DescribeFleetsInstances>(instances.length));
        }
        for (DescribeFleetsInstances ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public FleetData withInstances(Collection<DescribeFleetsInstances> instances) {
        this.setInstances(instances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivityStatus() != null) {
            sb.append("ActivityStatus: ").append(this.getActivityStatus()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getFleetId() != null) {
            sb.append("FleetId: ").append(this.getFleetId()).append(",");
        }
        if (this.getFleetState() != null) {
            sb.append("FleetState: ").append(this.getFleetState()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getExcessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.getExcessCapacityTerminationPolicy()).append(",");
        }
        if (this.getFulfilledCapacity() != null) {
            sb.append("FulfilledCapacity: ").append(this.getFulfilledCapacity()).append(",");
        }
        if (this.getFulfilledOnDemandCapacity() != null) {
            sb.append("FulfilledOnDemandCapacity: ").append(this.getFulfilledOnDemandCapacity()).append(",");
        }
        if (this.getLaunchTemplateConfigs() != null) {
            sb.append("LaunchTemplateConfigs: ").append(this.getLaunchTemplateConfigs()).append(",");
        }
        if (this.getTargetCapacitySpecification() != null) {
            sb.append("TargetCapacitySpecification: ").append(this.getTargetCapacitySpecification()).append(",");
        }
        if (this.getTerminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(this.getTerminateInstancesWithExpiration()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: ").append(this.getValidFrom()).append(",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: ").append(this.getValidUntil()).append(",");
        }
        if (this.getReplaceUnhealthyInstances() != null) {
            sb.append("ReplaceUnhealthyInstances: ").append(this.getReplaceUnhealthyInstances()).append(",");
        }
        if (this.getSpotOptions() != null) {
            sb.append("SpotOptions: ").append(this.getSpotOptions()).append(",");
        }
        if (this.getOnDemandOptions() != null) {
            sb.append("OnDemandOptions: ").append(this.getOnDemandOptions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetData)) {
            return false;
        }
        FleetData other = (FleetData)obj;
        if (other.getActivityStatus() == null ^ this.getActivityStatus() == null) {
            return false;
        }
        if (other.getActivityStatus() != null && !other.getActivityStatus().equals(this.getActivityStatus())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getFleetId() == null ^ this.getFleetId() == null) {
            return false;
        }
        if (other.getFleetId() != null && !other.getFleetId().equals(this.getFleetId())) {
            return false;
        }
        if (other.getFleetState() == null ^ this.getFleetState() == null) {
            return false;
        }
        if (other.getFleetState() != null && !other.getFleetState().equals(this.getFleetState())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() == null ^ this.getExcessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() != null && !other.getExcessCapacityTerminationPolicy().equals(this.getExcessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.getFulfilledCapacity() == null ^ this.getFulfilledCapacity() == null) {
            return false;
        }
        if (other.getFulfilledCapacity() != null && !other.getFulfilledCapacity().equals(this.getFulfilledCapacity())) {
            return false;
        }
        if (other.getFulfilledOnDemandCapacity() == null ^ this.getFulfilledOnDemandCapacity() == null) {
            return false;
        }
        if (other.getFulfilledOnDemandCapacity() != null && !other.getFulfilledOnDemandCapacity().equals(this.getFulfilledOnDemandCapacity())) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() == null ^ this.getLaunchTemplateConfigs() == null) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() != null && !other.getLaunchTemplateConfigs().equals(this.getLaunchTemplateConfigs())) {
            return false;
        }
        if (other.getTargetCapacitySpecification() == null ^ this.getTargetCapacitySpecification() == null) {
            return false;
        }
        if (other.getTargetCapacitySpecification() != null && !other.getTargetCapacitySpecification().equals(this.getTargetCapacitySpecification())) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() == null ^ this.getTerminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() != null && !other.getTerminateInstancesWithExpiration().equals(this.getTerminateInstancesWithExpiration())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.getReplaceUnhealthyInstances() == null ^ this.getReplaceUnhealthyInstances() == null) {
            return false;
        }
        if (other.getReplaceUnhealthyInstances() != null && !other.getReplaceUnhealthyInstances().equals(this.getReplaceUnhealthyInstances())) {
            return false;
        }
        if (other.getSpotOptions() == null ^ this.getSpotOptions() == null) {
            return false;
        }
        if (other.getSpotOptions() != null && !other.getSpotOptions().equals(this.getSpotOptions())) {
            return false;
        }
        if (other.getOnDemandOptions() == null ^ this.getOnDemandOptions() == null) {
            return false;
        }
        if (other.getOnDemandOptions() != null && !other.getOnDemandOptions().equals(this.getOnDemandOptions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        return other.getInstances() == null || other.getInstances().equals(this.getInstances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivityStatus() == null ? 0 : this.getActivityStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getFleetId() == null ? 0 : this.getFleetId().hashCode());
        hashCode = 31 * hashCode + (this.getFleetState() == null ? 0 : this.getFleetState().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getExcessCapacityTerminationPolicy() == null ? 0 : this.getExcessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getFulfilledCapacity() == null ? 0 : this.getFulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getFulfilledOnDemandCapacity() == null ? 0 : this.getFulfilledOnDemandCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplateConfigs() == null ? 0 : this.getLaunchTemplateConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacitySpecification() == null ? 0 : this.getTargetCapacitySpecification().hashCode());
        hashCode = 31 * hashCode + (this.getTerminateInstancesWithExpiration() == null ? 0 : this.getTerminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.getReplaceUnhealthyInstances() == null ? 0 : this.getReplaceUnhealthyInstances().hashCode());
        hashCode = 31 * hashCode + (this.getSpotOptions() == null ? 0 : this.getSpotOptions().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandOptions() == null ? 0 : this.getOnDemandOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        return hashCode;
    }

    public FleetData clone() {
        try {
            return (FleetData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

