/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CertificateAuthenticationRequest;
import com.amazonaws.services.ec2.model.ClientConnectOptions;
import com.amazonaws.services.ec2.model.ClientVpnAuthenticationRequest;
import com.amazonaws.services.ec2.model.ConnectionLogOptions;
import com.amazonaws.services.ec2.model.CreateClientVpnEndpointRequest;
import com.amazonaws.services.ec2.model.DirectoryServiceAuthenticationRequest;
import com.amazonaws.services.ec2.model.FederatedAuthenticationRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateClientVpnEndpointRequestMarshaller
implements Marshaller<Request<CreateClientVpnEndpointRequest>, CreateClientVpnEndpointRequest> {
    @Override
    public Request<CreateClientVpnEndpointRequest> marshall(CreateClientVpnEndpointRequest createClientVpnEndpointRequest) {
        ClientConnectOptions clientConnectOptions;
        SdkInternalList createClientVpnEndpointRequestSecurityGroupIdsList;
        SdkInternalList createClientVpnEndpointRequestDnsServersList;
        ConnectionLogOptions connectionLogOptions;
        SdkInternalList createClientVpnEndpointRequestAuthenticationOptionsList;
        if (createClientVpnEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateClientVpnEndpointRequest> request = new DefaultRequest<CreateClientVpnEndpointRequest>(createClientVpnEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateClientVpnEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClientVpnEndpointRequest.getClientCidrBlock() != null) {
            request.addParameter("ClientCidrBlock", StringUtils.fromString(createClientVpnEndpointRequest.getClientCidrBlock()));
        }
        if (createClientVpnEndpointRequest.getServerCertificateArn() != null) {
            request.addParameter("ServerCertificateArn", StringUtils.fromString(createClientVpnEndpointRequest.getServerCertificateArn()));
        }
        if (!(createClientVpnEndpointRequestAuthenticationOptionsList = (SdkInternalList)createClientVpnEndpointRequest.getAuthenticationOptions()).isEmpty() || !createClientVpnEndpointRequestAuthenticationOptionsList.isAutoConstruct()) {
            int authenticationOptionsListIndex = 1;
            for (ClientVpnAuthenticationRequest createClientVpnEndpointRequestAuthenticationOptionsListValue : createClientVpnEndpointRequestAuthenticationOptionsList) {
                FederatedAuthenticationRequest federatedAuthentication;
                CertificateAuthenticationRequest mutualAuthentication;
                Object activeDirectory;
                if (createClientVpnEndpointRequestAuthenticationOptionsListValue.getType() != null) {
                    request.addParameter("Authentication." + authenticationOptionsListIndex + ".Type", StringUtils.fromString(createClientVpnEndpointRequestAuthenticationOptionsListValue.getType()));
                }
                if ((activeDirectory = createClientVpnEndpointRequestAuthenticationOptionsListValue.getActiveDirectory()) != null && ((DirectoryServiceAuthenticationRequest)activeDirectory).getDirectoryId() != null) {
                    request.addParameter("Authentication." + authenticationOptionsListIndex + ".ActiveDirectory.DirectoryId", StringUtils.fromString(((DirectoryServiceAuthenticationRequest)activeDirectory).getDirectoryId()));
                }
                if ((mutualAuthentication = createClientVpnEndpointRequestAuthenticationOptionsListValue.getMutualAuthentication()) != null && mutualAuthentication.getClientRootCertificateChainArn() != null) {
                    request.addParameter("Authentication." + authenticationOptionsListIndex + ".MutualAuthentication.ClientRootCertificateChainArn", StringUtils.fromString(mutualAuthentication.getClientRootCertificateChainArn()));
                }
                if ((federatedAuthentication = createClientVpnEndpointRequestAuthenticationOptionsListValue.getFederatedAuthentication()) != null) {
                    if (federatedAuthentication.getSAMLProviderArn() != null) {
                        request.addParameter("Authentication." + authenticationOptionsListIndex + ".FederatedAuthentication.SAMLProviderArn", StringUtils.fromString(federatedAuthentication.getSAMLProviderArn()));
                    }
                    if (federatedAuthentication.getSelfServiceSAMLProviderArn() != null) {
                        request.addParameter("Authentication." + authenticationOptionsListIndex + ".FederatedAuthentication.SelfServiceSAMLProviderArn", StringUtils.fromString(federatedAuthentication.getSelfServiceSAMLProviderArn()));
                    }
                }
                ++authenticationOptionsListIndex;
            }
        }
        if ((connectionLogOptions = createClientVpnEndpointRequest.getConnectionLogOptions()) != null) {
            if (connectionLogOptions.getEnabled() != null) {
                request.addParameter("ConnectionLogOptions.Enabled", StringUtils.fromBoolean(connectionLogOptions.getEnabled()));
            }
            if (connectionLogOptions.getCloudwatchLogGroup() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogGroup", StringUtils.fromString(connectionLogOptions.getCloudwatchLogGroup()));
            }
            if (connectionLogOptions.getCloudwatchLogStream() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogStream", StringUtils.fromString(connectionLogOptions.getCloudwatchLogStream()));
            }
        }
        if (!(createClientVpnEndpointRequestDnsServersList = (SdkInternalList)createClientVpnEndpointRequest.getDnsServers()).isEmpty() || !createClientVpnEndpointRequestDnsServersList.isAutoConstruct()) {
            int dnsServersListIndex = 1;
            for (Object createClientVpnEndpointRequestDnsServersListValue : createClientVpnEndpointRequestDnsServersList) {
                if (createClientVpnEndpointRequestDnsServersListValue != null) {
                    request.addParameter("DnsServers." + dnsServersListIndex, StringUtils.fromString((String)createClientVpnEndpointRequestDnsServersListValue));
                }
                ++dnsServersListIndex;
            }
        }
        if (createClientVpnEndpointRequest.getTransportProtocol() != null) {
            request.addParameter("TransportProtocol", StringUtils.fromString(createClientVpnEndpointRequest.getTransportProtocol()));
        }
        if (createClientVpnEndpointRequest.getVpnPort() != null) {
            request.addParameter("VpnPort", StringUtils.fromInteger(createClientVpnEndpointRequest.getVpnPort()));
        }
        if (createClientVpnEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createClientVpnEndpointRequest.getDescription()));
        }
        if (createClientVpnEndpointRequest.getSplitTunnel() != null) {
            request.addParameter("SplitTunnel", StringUtils.fromBoolean(createClientVpnEndpointRequest.getSplitTunnel()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createClientVpnEndpointRequest.getClientToken()));
        SdkInternalList createClientVpnEndpointRequestTagSpecificationsList = (SdkInternalList)createClientVpnEndpointRequest.getTagSpecifications();
        if (!createClientVpnEndpointRequestTagSpecificationsList.isEmpty() || !createClientVpnEndpointRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createClientVpnEndpointRequestTagSpecificationsListValue : createClientVpnEndpointRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createClientVpnEndpointRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createClientVpnEndpointRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createClientVpnEndpointRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (!(createClientVpnEndpointRequestSecurityGroupIdsList = (SdkInternalList)createClientVpnEndpointRequest.getSecurityGroupIds()).isEmpty() || !createClientVpnEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String createClientVpnEndpointRequestSecurityGroupIdsListValue : createClientVpnEndpointRequestSecurityGroupIdsList) {
                if (createClientVpnEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(createClientVpnEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (createClientVpnEndpointRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createClientVpnEndpointRequest.getVpcId()));
        }
        if (createClientVpnEndpointRequest.getSelfServicePortal() != null) {
            request.addParameter("SelfServicePortal", StringUtils.fromString(createClientVpnEndpointRequest.getSelfServicePortal()));
        }
        if ((clientConnectOptions = createClientVpnEndpointRequest.getClientConnectOptions()) != null) {
            if (clientConnectOptions.getEnabled() != null) {
                request.addParameter("ClientConnectOptions.Enabled", StringUtils.fromBoolean(clientConnectOptions.getEnabled()));
            }
            if (clientConnectOptions.getLambdaFunctionArn() != null) {
                request.addParameter("ClientConnectOptions.LambdaFunctionArn", StringUtils.fromString(clientConnectOptions.getLambdaFunctionArn()));
            }
        }
        return request;
    }
}

