/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CapacityReservationTarget;
import com.amazonaws.services.ec2.model.CreateLaunchTemplateRequest;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.ElasticGpuSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6AddressRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateCpuOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateElasticInferenceAccelerator;
import com.amazonaws.services.ec2.model.LaunchTemplateEnclaveOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateHibernationOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateLicenseConfigurationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatePlacementRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateSpotMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatesMonitoringRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestLaunchTemplateData;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;

public class CreateLaunchTemplateRequestMarshaller
implements Marshaller<Request<CreateLaunchTemplateRequest>, CreateLaunchTemplateRequest> {
    @Override
    public Request<CreateLaunchTemplateRequest> marshall(CreateLaunchTemplateRequest createLaunchTemplateRequest) {
        SdkInternalList createLaunchTemplateRequestTagSpecificationsList;
        RequestLaunchTemplateData launchTemplateData;
        if (createLaunchTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLaunchTemplateRequest> request = new DefaultRequest<CreateLaunchTemplateRequest>(createLaunchTemplateRequest, "AmazonEC2");
        request.addParameter("Action", "CreateLaunchTemplate");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLaunchTemplateRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createLaunchTemplateRequest.getClientToken()));
        }
        if (createLaunchTemplateRequest.getLaunchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringUtils.fromString(createLaunchTemplateRequest.getLaunchTemplateName()));
        }
        if (createLaunchTemplateRequest.getVersionDescription() != null) {
            request.addParameter("VersionDescription", StringUtils.fromString(createLaunchTemplateRequest.getVersionDescription()));
        }
        if ((launchTemplateData = createLaunchTemplateRequest.getLaunchTemplateData()) != null) {
            LaunchTemplateEnclaveOptionsRequest enclaveOptions;
            LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;
            LaunchTemplateHibernationOptionsRequest hibernationOptions;
            SdkInternalList requestLaunchTemplateDataLicenseSpecificationsList;
            LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;
            LaunchTemplateCpuOptionsRequest cpuOptions;
            CreditSpecificationRequest creditSpecification;
            LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
            SdkInternalList requestLaunchTemplateDataSecurityGroupsList;
            SdkInternalList requestLaunchTemplateDataSecurityGroupIdsList;
            SdkInternalList requestLaunchTemplateDataElasticInferenceAcceleratorsList;
            SdkInternalList requestLaunchTemplateDataElasticGpuSpecificationsList;
            SdkInternalList requestLaunchTemplateDataTagSpecificationsList;
            LaunchTemplatePlacementRequest placement;
            LaunchTemplatesMonitoringRequest monitoring;
            SdkInternalList requestLaunchTemplateDataNetworkInterfacesList;
            SdkInternalList requestLaunchTemplateDataBlockDeviceMappingsList;
            LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
            if (launchTemplateData.getKernelId() != null) {
                request.addParameter("LaunchTemplateData.KernelId", StringUtils.fromString(launchTemplateData.getKernelId()));
            }
            if (launchTemplateData.getEbsOptimized() != null) {
                request.addParameter("LaunchTemplateData.EbsOptimized", StringUtils.fromBoolean(launchTemplateData.getEbsOptimized()));
            }
            if ((iamInstanceProfile = launchTemplateData.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchTemplateData.IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchTemplateData.IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.getName()));
                }
            }
            if (!(requestLaunchTemplateDataBlockDeviceMappingsList = (SdkInternalList)launchTemplateData.getBlockDeviceMappings()).isEmpty() || !requestLaunchTemplateDataBlockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (Object requestLaunchTemplateDataBlockDeviceMappingsListValue : requestLaunchTemplateDataBlockDeviceMappingsList) {
                    LaunchTemplateEbsBlockDeviceRequest ebs;
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getDeviceName() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getDeviceName()));
                    }
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getVirtualName() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getVirtualName()));
                    }
                    if ((ebs = ((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getEbs()) != null) {
                        if (ebs.getEncrypted() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                        }
                        if (ebs.getDeleteOnTermination() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                        }
                        if (ebs.getIops() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                        }
                        if (ebs.getKmsKeyId() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString(ebs.getKmsKeyId()));
                        }
                        if (ebs.getSnapshotId() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                        }
                        if (ebs.getVolumeSize() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                        }
                        if (ebs.getVolumeType() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                        }
                        if (ebs.getThroughput() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger(ebs.getThroughput()));
                        }
                    }
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getNoDevice() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getNoDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataNetworkInterfacesList = (SdkInternalList)launchTemplateData.getNetworkInterfaces()).isEmpty() || !requestLaunchTemplateDataNetworkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest requestLaunchTemplateDataNetworkInterfacesListValue : requestLaunchTemplateDataNetworkInterfacesList) {
                    SdkInternalList launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList;
                    Object launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList;
                    SdkInternalList launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList;
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getAssociateCarrierIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".AssociateCarrierIpAddress", StringUtils.fromBoolean(requestLaunchTemplateDataNetworkInterfacesListValue.getAssociateCarrierIpAddress()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(requestLaunchTemplateDataNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(requestLaunchTemplateDataNetworkInterfacesListValue.getDeleteOnTermination()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString(requestLaunchTemplateDataNetworkInterfacesListValue.getDescription()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(requestLaunchTemplateDataNetworkInterfacesListValue.getDeviceIndex()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getGroups()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        for (Object launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList) {
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getInterfaceType() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".InterfaceType", StringUtils.fromString(requestLaunchTemplateDataNetworkInterfacesListValue.getInterfaceType()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger(requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6AddressCount()));
                    }
                    if (!((ArrayList)(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6Addresses())).isEmpty() || !((SdkInternalList)launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList).isAutoConstruct()) {
                        Object launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue;
                        int ipv6AddressesListIndex = 1;
                        launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue = ((ArrayList)launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList).iterator();
                        while (launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue.hasNext()) {
                            InstanceIpv6AddressRequest launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue = (InstanceIpv6AddressRequest)launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue.next();
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue.getIpv6Address() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue.getIpv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(requestLaunchTemplateDataNetworkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList.isAutoConstruct()) {
                        int privateIpAddressesListIndex = 1;
                        for (Object launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList) {
                            if (((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrimary() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean(((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrimary()));
                            }
                            if (((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrivateIpAddress() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString(((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrivateIpAddress()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(requestLaunchTemplateDataNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(requestLaunchTemplateDataNetworkInterfacesListValue.getSubnetId()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkCardIndex() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".NetworkCardIndex", StringUtils.fromInteger(requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkCardIndex()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if (launchTemplateData.getImageId() != null) {
                request.addParameter("LaunchTemplateData.ImageId", StringUtils.fromString(launchTemplateData.getImageId()));
            }
            if (launchTemplateData.getInstanceType() != null) {
                request.addParameter("LaunchTemplateData.InstanceType", StringUtils.fromString(launchTemplateData.getInstanceType()));
            }
            if (launchTemplateData.getKeyName() != null) {
                request.addParameter("LaunchTemplateData.KeyName", StringUtils.fromString(launchTemplateData.getKeyName()));
            }
            if ((monitoring = launchTemplateData.getMonitoring()) != null && monitoring.getEnabled() != null) {
                request.addParameter("LaunchTemplateData.Monitoring.Enabled", StringUtils.fromBoolean(monitoring.getEnabled()));
            }
            if ((placement = launchTemplateData.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchTemplateData.Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                }
                if (placement.getAffinity() != null) {
                    request.addParameter("LaunchTemplateData.Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchTemplateData.Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                }
                if (placement.getHostId() != null) {
                    request.addParameter("LaunchTemplateData.Placement.HostId", StringUtils.fromString(placement.getHostId()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchTemplateData.Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
                }
                if (placement.getSpreadDomain() != null) {
                    request.addParameter("LaunchTemplateData.Placement.SpreadDomain", StringUtils.fromString(placement.getSpreadDomain()));
                }
                if (placement.getHostResourceGroupArn() != null) {
                    request.addParameter("LaunchTemplateData.Placement.HostResourceGroupArn", StringUtils.fromString(placement.getHostResourceGroupArn()));
                }
                if (placement.getPartitionNumber() != null) {
                    request.addParameter("LaunchTemplateData.Placement.PartitionNumber", StringUtils.fromInteger(placement.getPartitionNumber()));
                }
            }
            if (launchTemplateData.getRamDiskId() != null) {
                request.addParameter("LaunchTemplateData.RamDiskId", StringUtils.fromString(launchTemplateData.getRamDiskId()));
            }
            if (launchTemplateData.getDisableApiTermination() != null) {
                request.addParameter("LaunchTemplateData.DisableApiTermination", StringUtils.fromBoolean(launchTemplateData.getDisableApiTermination()));
            }
            if (launchTemplateData.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchTemplateData.InstanceInitiatedShutdownBehavior", StringUtils.fromString(launchTemplateData.getInstanceInitiatedShutdownBehavior()));
            }
            if (launchTemplateData.getUserData() != null) {
                request.addParameter("LaunchTemplateData.UserData", StringUtils.fromString(launchTemplateData.getUserData()));
            }
            if (!(requestLaunchTemplateDataTagSpecificationsList = (SdkInternalList)launchTemplateData.getTagSpecifications()).isEmpty() || !requestLaunchTemplateDataTagSpecificationsList.isAutoConstruct()) {
                int tagSpecificationsListIndex = 1;
                for (Object requestLaunchTemplateDataTagSpecificationsListValue : requestLaunchTemplateDataTagSpecificationsList) {
                    SdkInternalList launchTemplateTagSpecificationRequestTagsList;
                    if (((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).getResourceType() != null) {
                        request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).getResourceType()));
                    }
                    if (!(launchTemplateTagSpecificationRequestTagsList = (SdkInternalList)((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).getTags()).isEmpty() || !launchTemplateTagSpecificationRequestTagsList.isAutoConstruct()) {
                        int tagsListIndex = 1;
                        for (Tag launchTemplateTagSpecificationRequestTagsListValue : launchTemplateTagSpecificationRequestTagsList) {
                            if (launchTemplateTagSpecificationRequestTagsListValue.getKey() != null) {
                                request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(launchTemplateTagSpecificationRequestTagsListValue.getKey()));
                            }
                            if (launchTemplateTagSpecificationRequestTagsListValue.getValue() != null) {
                                request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(launchTemplateTagSpecificationRequestTagsListValue.getValue()));
                            }
                            ++tagsListIndex;
                        }
                    }
                    ++tagSpecificationsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataElasticGpuSpecificationsList = (SdkInternalList)launchTemplateData.getElasticGpuSpecifications()).isEmpty() || !requestLaunchTemplateDataElasticGpuSpecificationsList.isAutoConstruct()) {
                int elasticGpuSpecificationsListIndex = 1;
                for (ElasticGpuSpecification requestLaunchTemplateDataElasticGpuSpecificationsListValue : requestLaunchTemplateDataElasticGpuSpecificationsList) {
                    if (requestLaunchTemplateDataElasticGpuSpecificationsListValue.getType() != null) {
                        request.addParameter("LaunchTemplateData.ElasticGpuSpecification." + elasticGpuSpecificationsListIndex + ".Type", StringUtils.fromString(requestLaunchTemplateDataElasticGpuSpecificationsListValue.getType()));
                    }
                    ++elasticGpuSpecificationsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataElasticInferenceAcceleratorsList = (SdkInternalList)launchTemplateData.getElasticInferenceAccelerators()).isEmpty() || !requestLaunchTemplateDataElasticInferenceAcceleratorsList.isAutoConstruct()) {
                int elasticInferenceAcceleratorsListIndex = 1;
                for (LaunchTemplateElasticInferenceAccelerator requestLaunchTemplateDataElasticInferenceAcceleratorsListValue : requestLaunchTemplateDataElasticInferenceAcceleratorsList) {
                    if (requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getType() != null) {
                        request.addParameter("LaunchTemplateData.ElasticInferenceAccelerator." + elasticInferenceAcceleratorsListIndex + ".Type", StringUtils.fromString(requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getType()));
                    }
                    if (requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getCount() != null) {
                        request.addParameter("LaunchTemplateData.ElasticInferenceAccelerator." + elasticInferenceAcceleratorsListIndex + ".Count", StringUtils.fromInteger(requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getCount()));
                    }
                    ++elasticInferenceAcceleratorsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataSecurityGroupIdsList = (SdkInternalList)launchTemplateData.getSecurityGroupIds()).isEmpty() || !requestLaunchTemplateDataSecurityGroupIdsList.isAutoConstruct()) {
                int securityGroupIdsListIndex = 1;
                for (Object requestLaunchTemplateDataSecurityGroupIdsListValue : requestLaunchTemplateDataSecurityGroupIdsList) {
                    if (requestLaunchTemplateDataSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchTemplateData.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)requestLaunchTemplateDataSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataSecurityGroupsList = (SdkInternalList)launchTemplateData.getSecurityGroups()).isEmpty() || !requestLaunchTemplateDataSecurityGroupsList.isAutoConstruct()) {
                int securityGroupsListIndex = 1;
                for (String requestLaunchTemplateDataSecurityGroupsListValue : requestLaunchTemplateDataSecurityGroupsList) {
                    if (requestLaunchTemplateDataSecurityGroupsListValue != null) {
                        request.addParameter("LaunchTemplateData.SecurityGroup." + securityGroupsListIndex, StringUtils.fromString(requestLaunchTemplateDataSecurityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
            if ((instanceMarketOptions = launchTemplateData.getInstanceMarketOptions()) != null) {
                LaunchTemplateSpotMarketOptionsRequest spotOptions;
                if (instanceMarketOptions.getMarketType() != null) {
                    request.addParameter("LaunchTemplateData.InstanceMarketOptions.MarketType", StringUtils.fromString(instanceMarketOptions.getMarketType()));
                }
                if ((spotOptions = instanceMarketOptions.getSpotOptions()) != null) {
                    if (spotOptions.getMaxPrice() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.MaxPrice", StringUtils.fromString(spotOptions.getMaxPrice()));
                    }
                    if (spotOptions.getSpotInstanceType() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.SpotInstanceType", StringUtils.fromString(spotOptions.getSpotInstanceType()));
                    }
                    if (spotOptions.getBlockDurationMinutes() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.BlockDurationMinutes", StringUtils.fromInteger(spotOptions.getBlockDurationMinutes()));
                    }
                    if (spotOptions.getValidUntil() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.ValidUntil", StringUtils.fromDate(spotOptions.getValidUntil()));
                    }
                    if (spotOptions.getInstanceInterruptionBehavior() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString(spotOptions.getInstanceInterruptionBehavior()));
                    }
                }
            }
            if ((creditSpecification = launchTemplateData.getCreditSpecification()) != null && creditSpecification.getCpuCredits() != null) {
                request.addParameter("LaunchTemplateData.CreditSpecification.CpuCredits", StringUtils.fromString(creditSpecification.getCpuCredits()));
            }
            if ((cpuOptions = launchTemplateData.getCpuOptions()) != null) {
                if (cpuOptions.getCoreCount() != null) {
                    request.addParameter("LaunchTemplateData.CpuOptions.CoreCount", StringUtils.fromInteger(cpuOptions.getCoreCount()));
                }
                if (cpuOptions.getThreadsPerCore() != null) {
                    request.addParameter("LaunchTemplateData.CpuOptions.ThreadsPerCore", StringUtils.fromInteger(cpuOptions.getThreadsPerCore()));
                }
            }
            if ((capacityReservationSpecification = launchTemplateData.getCapacityReservationSpecification()) != null) {
                CapacityReservationTarget capacityReservationTarget;
                if (capacityReservationSpecification.getCapacityReservationPreference() != null) {
                    request.addParameter("LaunchTemplateData.CapacityReservationSpecification.CapacityReservationPreference", StringUtils.fromString(capacityReservationSpecification.getCapacityReservationPreference()));
                }
                if ((capacityReservationTarget = capacityReservationSpecification.getCapacityReservationTarget()) != null) {
                    if (capacityReservationTarget.getCapacityReservationId() != null) {
                        request.addParameter("LaunchTemplateData.CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationId", StringUtils.fromString(capacityReservationTarget.getCapacityReservationId()));
                    }
                    if (capacityReservationTarget.getCapacityReservationResourceGroupArn() != null) {
                        request.addParameter("LaunchTemplateData.CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationResourceGroupArn", StringUtils.fromString(capacityReservationTarget.getCapacityReservationResourceGroupArn()));
                    }
                }
            }
            if (!(requestLaunchTemplateDataLicenseSpecificationsList = (SdkInternalList)launchTemplateData.getLicenseSpecifications()).isEmpty() || !requestLaunchTemplateDataLicenseSpecificationsList.isAutoConstruct()) {
                int licenseSpecificationsListIndex = 1;
                for (LaunchTemplateLicenseConfigurationRequest requestLaunchTemplateDataLicenseSpecificationsListValue : requestLaunchTemplateDataLicenseSpecificationsList) {
                    if (requestLaunchTemplateDataLicenseSpecificationsListValue.getLicenseConfigurationArn() != null) {
                        request.addParameter("LaunchTemplateData.LicenseSpecification." + licenseSpecificationsListIndex + ".LicenseConfigurationArn", StringUtils.fromString(requestLaunchTemplateDataLicenseSpecificationsListValue.getLicenseConfigurationArn()));
                    }
                    ++licenseSpecificationsListIndex;
                }
            }
            if ((hibernationOptions = launchTemplateData.getHibernationOptions()) != null && hibernationOptions.getConfigured() != null) {
                request.addParameter("LaunchTemplateData.HibernationOptions.Configured", StringUtils.fromBoolean(hibernationOptions.getConfigured()));
            }
            if ((metadataOptions = launchTemplateData.getMetadataOptions()) != null) {
                if (metadataOptions.getHttpTokens() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpTokens", StringUtils.fromString(metadataOptions.getHttpTokens()));
                }
                if (metadataOptions.getHttpPutResponseHopLimit() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpPutResponseHopLimit", StringUtils.fromInteger(metadataOptions.getHttpPutResponseHopLimit()));
                }
                if (metadataOptions.getHttpEndpoint() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpEndpoint", StringUtils.fromString(metadataOptions.getHttpEndpoint()));
                }
            }
            if ((enclaveOptions = launchTemplateData.getEnclaveOptions()) != null && enclaveOptions.getEnabled() != null) {
                request.addParameter("LaunchTemplateData.EnclaveOptions.Enabled", StringUtils.fromBoolean(enclaveOptions.getEnabled()));
            }
        }
        if (!(createLaunchTemplateRequestTagSpecificationsList = (SdkInternalList)createLaunchTemplateRequest.getTagSpecifications()).isEmpty() || !createLaunchTemplateRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createLaunchTemplateRequestTagSpecificationsListValue : createLaunchTemplateRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createLaunchTemplateRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createLaunchTemplateRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createLaunchTemplateRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

