/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFleetsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFleetsRequestMarshaller
implements Marshaller<Request<DescribeFleetsRequest>, DescribeFleetsRequest> {
    @Override
    public Request<DescribeFleetsRequest> marshall(DescribeFleetsRequest describeFleetsRequest) {
        SdkInternalList describeFleetsRequestFiltersList;
        SdkInternalList describeFleetsRequestFleetIdsList;
        if (describeFleetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetsRequest> request = new DefaultRequest<DescribeFleetsRequest>(describeFleetsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFleets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeFleetsRequest.getMaxResults()));
        }
        if (describeFleetsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeFleetsRequest.getNextToken()));
        }
        if (!(describeFleetsRequestFleetIdsList = (SdkInternalList)describeFleetsRequest.getFleetIds()).isEmpty() || !describeFleetsRequestFleetIdsList.isAutoConstruct()) {
            int fleetIdsListIndex = 1;
            for (String describeFleetsRequestFleetIdsListValue : describeFleetsRequestFleetIdsList) {
                if (describeFleetsRequestFleetIdsListValue != null) {
                    request.addParameter("FleetId." + fleetIdsListIndex, StringUtils.fromString(describeFleetsRequestFleetIdsListValue));
                }
                ++fleetIdsListIndex;
            }
        }
        if (!(describeFleetsRequestFiltersList = (SdkInternalList)describeFleetsRequest.getFilters()).isEmpty() || !describeFleetsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeFleetsRequestFiltersListValue : describeFleetsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeFleetsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeFleetsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFleetsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

