/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeTrafficMirrorTargetsRequestMarshaller
implements Marshaller<Request<DescribeTrafficMirrorTargetsRequest>, DescribeTrafficMirrorTargetsRequest> {
    @Override
    public Request<DescribeTrafficMirrorTargetsRequest> marshall(DescribeTrafficMirrorTargetsRequest describeTrafficMirrorTargetsRequest) {
        SdkInternalList describeTrafficMirrorTargetsRequestFiltersList;
        if (describeTrafficMirrorTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTrafficMirrorTargetsRequest> request = new DefaultRequest<DescribeTrafficMirrorTargetsRequest>(describeTrafficMirrorTargetsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeTrafficMirrorTargets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsList = (SdkInternalList)describeTrafficMirrorTargetsRequest.getTrafficMirrorTargetIds();
        if (!describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsList.isEmpty() || !describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsList.isAutoConstruct()) {
            int trafficMirrorTargetIdsListIndex = 1;
            for (String describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsListValue : describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsList) {
                if (describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsListValue != null) {
                    request.addParameter("TrafficMirrorTargetId." + trafficMirrorTargetIdsListIndex, StringUtils.fromString(describeTrafficMirrorTargetsRequestTrafficMirrorTargetIdsListValue));
                }
                ++trafficMirrorTargetIdsListIndex;
            }
        }
        if (!(describeTrafficMirrorTargetsRequestFiltersList = (SdkInternalList)describeTrafficMirrorTargetsRequest.getFilters()).isEmpty() || !describeTrafficMirrorTargetsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeTrafficMirrorTargetsRequestFiltersListValue : describeTrafficMirrorTargetsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeTrafficMirrorTargetsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeTrafficMirrorTargetsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeTrafficMirrorTargetsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeTrafficMirrorTargetsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeTrafficMirrorTargetsRequest.getMaxResults()));
        }
        if (describeTrafficMirrorTargetsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeTrafficMirrorTargetsRequest.getNextToken()));
        }
        return request;
    }
}

