/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeTransitGatewayAttachmentsRequestMarshaller
implements Marshaller<Request<DescribeTransitGatewayAttachmentsRequest>, DescribeTransitGatewayAttachmentsRequest> {
    @Override
    public Request<DescribeTransitGatewayAttachmentsRequest> marshall(DescribeTransitGatewayAttachmentsRequest describeTransitGatewayAttachmentsRequest) {
        SdkInternalList describeTransitGatewayAttachmentsRequestFiltersList;
        if (describeTransitGatewayAttachmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTransitGatewayAttachmentsRequest> request = new DefaultRequest<DescribeTransitGatewayAttachmentsRequest>(describeTransitGatewayAttachmentsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeTransitGatewayAttachments");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsList = (SdkInternalList)describeTransitGatewayAttachmentsRequest.getTransitGatewayAttachmentIds();
        if (!describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsList.isEmpty() || !describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsList.isAutoConstruct()) {
            int transitGatewayAttachmentIdsListIndex = 1;
            for (String describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsListValue : describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsList) {
                if (describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsListValue != null) {
                    request.addParameter("TransitGatewayAttachmentIds." + transitGatewayAttachmentIdsListIndex, StringUtils.fromString(describeTransitGatewayAttachmentsRequestTransitGatewayAttachmentIdsListValue));
                }
                ++transitGatewayAttachmentIdsListIndex;
            }
        }
        if (!(describeTransitGatewayAttachmentsRequestFiltersList = (SdkInternalList)describeTransitGatewayAttachmentsRequest.getFilters()).isEmpty() || !describeTransitGatewayAttachmentsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeTransitGatewayAttachmentsRequestFiltersListValue : describeTransitGatewayAttachmentsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeTransitGatewayAttachmentsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeTransitGatewayAttachmentsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeTransitGatewayAttachmentsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeTransitGatewayAttachmentsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeTransitGatewayAttachmentsRequest.getMaxResults()));
        }
        if (describeTransitGatewayAttachmentsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeTransitGatewayAttachmentsRequest.getNextToken()));
        }
        return request;
    }
}

