/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.HistoryRecordEntry;
import com.amazonaws.services.ec2.model.transform.EventInformationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class HistoryRecordEntryStaxUnmarshaller
implements Unmarshaller<HistoryRecordEntry, StaxUnmarshallerContext> {
    private static HistoryRecordEntryStaxUnmarshaller instance;

    @Override
    public HistoryRecordEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        HistoryRecordEntry historyRecordEntry = new HistoryRecordEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return historyRecordEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("eventInformation", targetDepth)) {
                    historyRecordEntry.setEventInformation(EventInformationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventType", targetDepth)) {
                    historyRecordEntry.setEventType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("timestamp", targetDepth)) continue;
                historyRecordEntry.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return historyRecordEntry;
    }

    public static HistoryRecordEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HistoryRecordEntryStaxUnmarshaller();
        }
        return instance;
    }
}

