/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ReplaceTransitGatewayRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceTransitGatewayRouteRequestMarshaller
implements Marshaller<Request<ReplaceTransitGatewayRouteRequest>, ReplaceTransitGatewayRouteRequest> {
    @Override
    public Request<ReplaceTransitGatewayRouteRequest> marshall(ReplaceTransitGatewayRouteRequest replaceTransitGatewayRouteRequest) {
        if (replaceTransitGatewayRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReplaceTransitGatewayRouteRequest> request = new DefaultRequest<ReplaceTransitGatewayRouteRequest>(replaceTransitGatewayRouteRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceTransitGatewayRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceTransitGatewayRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(replaceTransitGatewayRouteRequest.getDestinationCidrBlock()));
        }
        if (replaceTransitGatewayRouteRequest.getTransitGatewayRouteTableId() != null) {
            request.addParameter("TransitGatewayRouteTableId", StringUtils.fromString(replaceTransitGatewayRouteRequest.getTransitGatewayRouteTableId()));
        }
        if (replaceTransitGatewayRouteRequest.getTransitGatewayAttachmentId() != null) {
            request.addParameter("TransitGatewayAttachmentId", StringUtils.fromString(replaceTransitGatewayRouteRequest.getTransitGatewayAttachmentId()));
        }
        if (replaceTransitGatewayRouteRequest.getBlackhole() != null) {
            request.addParameter("Blackhole", StringUtils.fromBoolean(replaceTransitGatewayRouteRequest.getBlackhole()));
        }
        return request;
    }
}

