/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.LeasingException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.GenericLeaseSelector;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import com.amazonaws.services.kinesis.leases.impl.LeaseRenewer;
import com.amazonaws.services.kinesis.leases.impl.LeaseTaker;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseRenewer;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseTaker;
import com.amazonaws.services.kinesis.leases.interfaces.LeaseSelector;
import com.amazonaws.services.kinesis.metrics.impl.LogMetricsFactory;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeaseCoordinator<T extends Lease> {
    public static final String WORKER_IDENTIFIER_METRIC = "WorkerIdentifier";
    private static final Log LOG = LogFactory.getLog(LeaseCoordinator.class);
    private static final long STOP_WAIT_TIME_MILLIS = 2000L;
    private static final int DEFAULT_MAX_LEASES_FOR_WORKER = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_LEASES_TO_STEAL_AT_ONE_TIME = 1;
    private static final ThreadFactory LEASE_COORDINATOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("LeaseCoordinator-%04d").setDaemon(true).build();
    private static final ThreadFactory LEASE_RENEWAL_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("LeaseRenewer-%04d").setDaemon(true).build();
    private final ILeaseRenewer<T> leaseRenewer;
    private final ILeaseTaker<T> leaseTaker;
    private final long renewerIntervalMillis;
    private final long takerIntervalMillis;
    private final Object shutdownLock = new Object();
    protected final IMetricsFactory metricsFactory;
    private ScheduledExecutorService leaseCoordinatorThreadPool;
    private final ExecutorService leaseRenewalThreadpool;
    private volatile boolean running = false;
    private ScheduledFuture<?> takerFuture;

    private static <T extends Lease> LeaseSelector<T> getDefaultLeaseSelector() {
        return new GenericLeaseSelector();
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis) {
        this(leaseManager, workerIdentifier, leaseDurationMillis, epsilonMillis, new LogMetricsFactory());
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, LeaseSelector<T> leaseSelector, String workerIdentifier, long leaseDurationMillis, long epsilonMillis) {
        this(leaseManager, leaseSelector, workerIdentifier, leaseDurationMillis, epsilonMillis, new LogMetricsFactory());
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, IMetricsFactory metricsFactory) {
        this(leaseManager, workerIdentifier, leaseDurationMillis, epsilonMillis, Integer.MAX_VALUE, 1, 20, metricsFactory);
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, LeaseSelector<T> leaseSelector, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, IMetricsFactory metricsFactory) {
        this(leaseManager, leaseSelector, workerIdentifier, leaseDurationMillis, epsilonMillis, Integer.MAX_VALUE, 1, 20, metricsFactory);
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewerThreadCount, IMetricsFactory metricsFactory) {
        this(leaseManager, LeaseCoordinator.getDefaultLeaseSelector(), workerIdentifier, leaseDurationMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewerThreadCount, metricsFactory);
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, LeaseSelector<T> leaseSelector, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewerThreadCount, IMetricsFactory metricsFactory) {
        this.leaseRenewalThreadpool = LeaseCoordinator.getLeaseRenewalExecutorService(maxLeaseRenewerThreadCount);
        this.leaseTaker = new LeaseTaker<T>(leaseManager, leaseSelector, workerIdentifier, leaseDurationMillis).withMaxLeasesForWorker(maxLeasesForWorker).withMaxLeasesToStealAtOneTime(maxLeasesToStealAtOneTime);
        this.leaseRenewer = new LeaseRenewer<T>(leaseManager, workerIdentifier, leaseDurationMillis, this.leaseRenewalThreadpool);
        this.renewerIntervalMillis = leaseDurationMillis / 3L - epsilonMillis;
        this.takerIntervalMillis = (leaseDurationMillis + epsilonMillis) * 2L;
        this.metricsFactory = metricsFactory;
        LOG.info(String.format("With failover time %d ms and epsilon %d ms, LeaseCoordinator will renew leases every %d ms, takeleases every %d ms, process maximum of %d leases and steal %d lease(s) at a time.", leaseDurationMillis, epsilonMillis, this.renewerIntervalMillis, this.takerIntervalMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime));
    }

    public void start() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.leaseRenewer.initialize();
        this.leaseCoordinatorThreadPool = Executors.newScheduledThreadPool(2, LEASE_COORDINATOR_THREAD_FACTORY);
        this.takerFuture = this.leaseCoordinatorThreadPool.scheduleWithFixedDelay(new TakerRunnable(), 0L, this.takerIntervalMillis, TimeUnit.MILLISECONDS);
        this.leaseCoordinatorThreadPool.scheduleAtFixedRate(new RenewerRunnable(), 0L, this.renewerIntervalMillis, TimeUnit.MILLISECONDS);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTaker() throws DependencyException, InvalidStateException {
        IMetricsScope scope = MetricsHelper.startScope(this.metricsFactory, "TakeLeases");
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            Map<String, T> takenLeases = this.leaseTaker.takeLeases();
            Object object = this.shutdownLock;
            synchronized (object) {
                if (this.running) {
                    this.leaseRenewer.addLeasesToRenew(takenLeases.values());
                }
            }
            success = true;
        }
        finally {
            scope.addDimension(WORKER_IDENTIFIER_METRIC, this.getWorkerIdentifier());
            MetricsHelper.addSuccessAndLatency(startTime, success, MetricsLevel.SUMMARY);
            MetricsHelper.endScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRenewer() throws DependencyException, InvalidStateException {
        IMetricsScope scope = MetricsHelper.startScope(this.metricsFactory, "RenewAllLeases");
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            this.leaseRenewer.renewLeases();
            success = true;
        }
        finally {
            scope.addDimension(WORKER_IDENTIFIER_METRIC, this.getWorkerIdentifier());
            MetricsHelper.addSuccessAndLatency(startTime, success, MetricsLevel.SUMMARY);
            MetricsHelper.endScope();
        }
    }

    public Collection<T> getAssignments() {
        return this.leaseRenewer.getCurrentlyHeldLeases().values();
    }

    public T getCurrentlyHeldLease(String leaseKey) {
        return this.leaseRenewer.getCurrentlyHeldLease(leaseKey);
    }

    public String getWorkerIdentifier() {
        return this.leaseTaker.getWorkerIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block8: {
            if (this.leaseCoordinatorThreadPool != null) {
                this.leaseCoordinatorThreadPool.shutdown();
                try {
                    if (this.leaseCoordinatorThreadPool.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        LOG.info(String.format("Worker %s has successfully stopped lease-tracking threads", this.leaseTaker.getWorkerIdentifier()));
                        break block8;
                    }
                    this.leaseCoordinatorThreadPool.shutdownNow();
                    LOG.info(String.format("Worker %s stopped lease-tracking threads %dms after stop", this.leaseTaker.getWorkerIdentifier(), 2000L));
                }
                catch (InterruptedException e) {
                    LOG.debug("Encountered InterruptedException when awaiting threadpool termination");
                }
            } else {
                LOG.debug("Threadpool was null, no need to shutdown/terminate threadpool.");
            }
        }
        this.leaseRenewalThreadpool.shutdownNow();
        Object object = this.shutdownLock;
        synchronized (object) {
            this.leaseRenewer.clearCurrentlyHeldLeases();
            this.running = false;
        }
    }

    public void stopLeaseTaker() {
        this.takerFuture.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropLease(T lease) {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (lease != null) {
                this.leaseRenewer.dropLease(lease);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean updateLease(T lease, UUID concurrencyToken) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        return this.leaseRenewer.updateLease(lease, concurrencyToken);
    }

    private static ExecutorService getLeaseRenewalExecutorService(int maximumPoolSize) {
        int coreLeaseCount = Math.max(maximumPoolSize / 4, 2);
        return new ThreadPoolExecutor(coreLeaseCount, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), LEASE_RENEWAL_THREAD_FACTORY);
    }

    private class RenewerRunnable
    implements Runnable {
        private RenewerRunnable() {
        }

        @Override
        public void run() {
            try {
                LeaseCoordinator.this.runRenewer();
            }
            catch (LeasingException e) {
                LOG.error("LeasingException encountered in lease renewing thread", e);
            }
            catch (Throwable t) {
                LOG.error("Throwable encountered in lease renewing thread", t);
            }
        }
    }

    private class TakerRunnable
    implements Runnable {
        private TakerRunnable() {
        }

        @Override
        public void run() {
            try {
                LeaseCoordinator.this.runTaker();
            }
            catch (LeasingException e) {
                LOG.error("LeasingException encountered in lease taking thread", e);
            }
            catch (Throwable t) {
                LOG.error("Throwable encountered in lease taking thread", t);
            }
        }
    }
}

