/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.cloudwatch;

import javax.annotation.Nullable;
import org.graylog.aws.cloudwatch.CloudWatchLogEntry;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowLogMessage {
    private static final Logger LOG = LoggerFactory.getLogger(FlowLogMessage.class);
    private final DateTime timestamp;
    private final int version;
    private final String accountId;
    private final String interfaceId;
    private final String sourceAddress;
    private final String destinationAddress;
    private final int sourcePort;
    private final int destinationPort;
    private final int protocolNumber;
    private final long packets;
    private final long bytes;
    private final DateTime captureWindowStart;
    private final DateTime captureWindowEnd;
    private final String action;
    private final String logStatus;

    public FlowLogMessage(DateTime timestamp, int version, String accountId, String interfaceId, String sourceAddress, String destinationAddress, int sourcePort, int destinationPort, int protocolNumber, long packets, long bytes, DateTime captureWindowStart, DateTime captureWindowEnd, String action, String logStatus) {
        this.timestamp = timestamp;
        this.version = version;
        this.accountId = accountId;
        this.interfaceId = interfaceId;
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.sourcePort = sourcePort;
        this.destinationPort = destinationPort;
        this.protocolNumber = protocolNumber;
        this.packets = packets;
        this.bytes = bytes;
        this.captureWindowStart = captureWindowStart;
        this.captureWindowEnd = captureWindowEnd;
        this.action = action;
        this.logStatus = logStatus;
    }

    @Nullable
    public static FlowLogMessage fromLogEvent(CloudWatchLogEntry logEvent) {
        String[] parts = logEvent.message.split(" ");
        if (parts.length != 14) {
            LOG.warn("Received FlowLog message with not exactly 14 fields. Skipping. Message was: [{}]", (Object)logEvent.message);
            return null;
        }
        return new FlowLogMessage(new DateTime((Object)logEvent.timestamp), FlowLogMessage.safeInteger(parts[0]), parts[1], parts[2], parts[3], parts[4], FlowLogMessage.safeInteger(parts[5]), FlowLogMessage.safeInteger(parts[6]), FlowLogMessage.safeInteger(parts[7]), FlowLogMessage.safeLong(parts[8]), FlowLogMessage.safeLong(parts[9]), new DateTime(Long.valueOf(parts[10]) * 1000L), new DateTime(Long.valueOf(parts[11]) * 1000L), parts[12], parts[13]);
    }

    private static int safeInteger(String x) {
        if ("-".equals(x)) {
            return 0;
        }
        try {
            return Integer.valueOf(x);
        }
        catch (Exception e) {
            LOG.debug("Could not parse value of FlowLog message to Integer.", (Throwable)e);
            return 0;
        }
    }

    private static long safeLong(String x) {
        if ("-".equals(x)) {
            return 0L;
        }
        try {
            return Long.valueOf(x);
        }
        catch (Exception e) {
            LOG.debug("Could not parse value of FlowLog message to Long.", (Throwable)e);
            return 0L;
        }
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public int getVersion() {
        return this.version;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public int getProtocolNumber() {
        return this.protocolNumber;
    }

    public long getPackets() {
        return this.packets;
    }

    public long getBytes() {
        return this.bytes;
    }

    public DateTime getCaptureWindowStart() {
        return this.captureWindowStart;
    }

    public DateTime getCaptureWindowEnd() {
        return this.captureWindowEnd;
    }

    public String getAction() {
        return this.action;
    }

    public String getLogStatus() {
        return this.logStatus;
    }
}

