/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.cloudtrail.notifications;

import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;
import org.graylog.aws.auth.AWSAuthProvider;
import org.graylog.aws.config.Proxy;
import org.graylog.aws.inputs.cloudtrail.notifications.CloudtrailSNSNotification;
import org.graylog.aws.inputs.cloudtrail.notifications.CloudtrailSNSNotificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudtrailSQSClient {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtrailSQSClient.class);
    private final AmazonSQS sqs;
    private final String queueName;
    private final ObjectMapper objectMapper;

    public CloudtrailSQSClient(Region region, String queueName, AWSAuthProvider authProvider, HttpUrl proxyUrl, ObjectMapper objectMapper) {
        AmazonSQSClientBuilder clientBuilder = (AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withRegion(region.getName())).withCredentials(authProvider);
        if (proxyUrl != null) {
            clientBuilder.withClientConfiguration(Proxy.forAWS(proxyUrl));
        }
        this.sqs = (AmazonSQS)clientBuilder.build();
        this.queueName = queueName;
        this.objectMapper = objectMapper;
    }

    public List<CloudtrailSNSNotification> getNotifications() {
        LOG.debug("Fetching SQS CloudTrail notifications.");
        ArrayList notifications = Lists.newArrayList();
        ReceiveMessageRequest request = new ReceiveMessageRequest(this.queueName);
        request.setMaxNumberOfMessages(10);
        ReceiveMessageResult result = this.sqs.receiveMessage(request);
        LOG.debug("Received [{}] SQS CloudTrail notifications.", (Object)result.getMessages().size());
        CloudtrailSNSNotificationParser parser = new CloudtrailSNSNotificationParser(this.objectMapper);
        LOG.debug("Finished parsing notifications.");
        for (Message message : result.getMessages()) {
            notifications.addAll(parser.parse(message));
        }
        LOG.debug("Returning notifications.");
        return notifications;
    }

    public void deleteNotification(CloudtrailSNSNotification notification) {
        LOG.debug("Deleting SQS CloudTrail notification <{}>.", (Object)notification.getReceiptHandle());
        this.sqs.deleteMessage(new DeleteMessageRequest().withQueueUrl(this.queueName).withReceiptHandle(notification.getReceiptHandle()));
    }
}

