/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.otx;

import com.google.common.base.Joiner;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog.plugins.threatintel.functions.otx.OTXIntel;

public class OTXLookupResult
extends ForwardingMap<String, Object> {
    private final ImmutableMap<String, Object> results;
    public static final OTXLookupResult EMPTY = new EmptyOTXLookupResult();
    public static final OTXLookupResult FALSE = new FalseOTXLookupResult();

    public static OTXLookupResult buildFromIntel(OTXIntel intel) {
        if (intel.getPulseCount() > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"otx_threat_indicated", (Object)true);
            Joiner joiner = Joiner.on((String)", ").skipNulls();
            builder.put((Object)"otx_threat_ids", (Object)joiner.join(intel.getPulseIds()));
            builder.put((Object)"otx_threat_names", (Object)joiner.join(intel.getPulseNames()));
            return new OTXLookupResult((ImmutableMap<String, Object>)builder.build());
        }
        return FALSE;
    }

    public OTXLookupResult(ImmutableMap<String, Object> fields) {
        this.results = fields;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    protected Map<String, Object> delegate() {
        return this.getResults();
    }

    private static class EmptyOTXLookupResult
    extends OTXLookupResult {
        private static final ImmutableMap<String, Object> EMPTY = ImmutableMap.builder().build();

        private EmptyOTXLookupResult() {
            super(EMPTY);
        }
    }

    private static class FalseOTXLookupResult
    extends OTXLookupResult {
        private static final ImmutableMap<String, Object> EMPTY = ImmutableMap.builder().put((Object)"otx_threat_indicated", (Object)false).build();

        private FalseOTXLookupResult() {
            super(EMPTY);
        }
    }
}

