/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.config.idle.HttpReapableConnectionManager;
import io.searchbox.client.config.idle.IdleConnectionReaper;
import io.searchbox.client.http.JestHttpClient;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.client.AuthCache;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private HttpClientConfig httpClientConfig;

    public JestClient getObject() {
        JestHttpClient client = new JestHttpClient();
        if (this.httpClientConfig == null) {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            this.httpClientConfig = new HttpClientConfig.Builder("http://localhost:9200").build();
        }
        client.setRequestCompressionEnabled(this.httpClientConfig.isRequestCompressionEnabled());
        client.setServers(this.httpClientConfig.getServerList());
        HttpClientConnectionManager connectionManager = this.getConnectionManager();
        NHttpClientConnectionManager asyncConnectionManager = this.getAsyncConnectionManager();
        client.setHttpClient(this.createHttpClient(connectionManager));
        client.setAsyncClient(this.createAsyncHttpClient(asyncConnectionManager));
        client.setRetryHandler(this.httpClientConfig.getRetryHandler());
        ObjectMapper objectMapper = this.httpClientConfig.getObjectMapper();
        if (objectMapper == null) {
            log.info("Using default ObjectMapper instance");
        } else {
            log.info("Using custom ObjectMapper instance");
            client.setObjectMapper(objectMapper);
        }
        if (this.httpClientConfig.isDiscoveryEnabled()) {
            log.info("Node Discovery enabled...");
            if (!Strings.isNullOrEmpty((String)this.httpClientConfig.getDiscoveryFilter())) {
                log.info("Node Discovery filtering nodes on \"{}\"", (Object)this.httpClientConfig.getDiscoveryFilter());
            }
            NodeChecker nodeChecker = this.createNodeChecker(client, this.httpClientConfig);
            client.setNodeChecker(nodeChecker);
            nodeChecker.startAsync();
            nodeChecker.awaitRunning();
        } else {
            log.info("Node Discovery disabled...");
        }
        if (this.httpClientConfig.getMaxConnectionIdleTime() > 0L) {
            log.info("Idle connection reaping enabled...");
            IdleConnectionReaper reaper = new IdleConnectionReaper(this.httpClientConfig, new HttpReapableConnectionManager(connectionManager, asyncConnectionManager));
            client.setIdleConnectionReaper(reaper);
            reaper.startAsync();
            reaper.awaitRunning();
        } else {
            log.info("Idle connection reaping disabled...");
        }
        Set<HttpHost> preemptiveAuthTargetHosts = this.httpClientConfig.getPreemptiveAuthTargetHosts();
        if (!preemptiveAuthTargetHosts.isEmpty()) {
            log.info("Authentication cache set for preemptive authentication");
            client.setHttpClientContextTemplate(this.createPreemptiveAuthContext(preemptiveAuthTargetHosts));
        }
        return client;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return this.configureHttpClient(HttpClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.httpClientConfig.getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.httpClientConfig.getCredentialsProvider())).build();
    }

    private CloseableHttpAsyncClient createAsyncHttpClient(NHttpClientConnectionManager connectionManager) {
        return this.configureHttpClient(HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.httpClientConfig.getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.httpClientConfig.getCredentialsProvider())).build();
    }

    protected HttpClientBuilder configureHttpClient(HttpClientBuilder builder) {
        return builder;
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder builder) {
        return builder;
    }

    protected HttpRoutePlanner getRoutePlanner() {
        return this.httpClientConfig.getHttpRoutePlanner();
    }

    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.httpClientConfig.getConnTimeout()).setSocketTimeout(this.httpClientConfig.getReadTimeout()).build();
    }

    protected NHttpClientConnectionManager getAsyncConnectionManager() {
        Integer defaultMaxPerRoute;
        PoolingNHttpClientConnectionManager retval;
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout(this.httpClientConfig.getConnTimeout()).setSoTimeout(this.httpClientConfig.getReadTimeout()).build();
        Registry<SchemeIOSessionStrategy> sessionStrategyRegistry = RegistryBuilder.create().register("http", this.httpClientConfig.getHttpIOSessionStrategy()).register("https", this.httpClientConfig.getHttpsIOSessionStrategy()).build();
        try {
            retval = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(ioReactorConfig), sessionStrategyRegistry);
        }
        catch (IOReactorException e) {
            throw new IllegalStateException(e);
        }
        Integer maxTotal = this.httpClientConfig.getMaxTotalConnection();
        if (maxTotal != null) {
            retval.setMaxTotal(maxTotal);
        }
        if ((defaultMaxPerRoute = this.httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
            retval.setDefaultMaxPerRoute(defaultMaxPerRoute);
        }
        Map<HttpRoute, Integer> maxPerRoute = this.httpClientConfig.getMaxTotalConnectionPerRoute();
        for (Map.Entry<HttpRoute, Integer> entry : maxPerRoute.entrySet()) {
            retval.setMaxPerRoute(entry.getKey(), (int)entry.getValue());
        }
        return retval;
    }

    protected HttpClientConnectionManager getConnectionManager() {
        HttpClientConnectionManager retval;
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", this.httpClientConfig.getPlainSocketFactory()).register("https", this.httpClientConfig.getSslSocketFactory()).build();
        if (this.httpClientConfig.isMultiThreaded()) {
            Integer defaultMaxPerRoute;
            log.info("Using multi thread/connection supporting pooling connection manager");
            PoolingHttpClientConnectionManager poolingConnMgr = new PoolingHttpClientConnectionManager(registry);
            Integer maxTotal = this.httpClientConfig.getMaxTotalConnection();
            if (maxTotal != null) {
                poolingConnMgr.setMaxTotal(maxTotal);
            }
            if ((defaultMaxPerRoute = this.httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                poolingConnMgr.setDefaultMaxPerRoute(defaultMaxPerRoute);
            }
            Map<HttpRoute, Integer> maxPerRoute = this.httpClientConfig.getMaxTotalConnectionPerRoute();
            for (Map.Entry<HttpRoute, Integer> entry : maxPerRoute.entrySet()) {
                poolingConnMgr.setMaxPerRoute(entry.getKey(), (int)entry.getValue());
            }
            retval = poolingConnMgr;
        } else {
            log.info("Using single thread/connection supporting basic connection manager");
            retval = new BasicHttpClientConnectionManager(registry);
        }
        return retval;
    }

    protected NodeChecker createNodeChecker(JestHttpClient client, HttpClientConfig httpClientConfig) {
        return new NodeChecker(client, httpClientConfig);
    }

    protected HttpClientContext createPreemptiveAuthContext(Set<HttpHost> targetHosts) {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(this.httpClientConfig.getCredentialsProvider());
        context.setAuthCache(this.createBasicAuthCache(targetHosts));
        return context;
    }

    private AuthCache createBasicAuthCache(Set<HttpHost> targetHosts) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        for (HttpHost eachTargetHost : targetHosts) {
            authCache.put(eachTargetHost, basicAuth);
        }
        return authCache;
    }
}

