/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config;

import io.searchbox.client.JestRetryHandler;
import io.searchbox.client.NoopRetryHandler;
import io.searchbox.client.config.ClientConfig;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;

public class HttpClientConfig
extends ClientConfig {
    private final Integer maxTotalConnection;
    private final Integer defaultMaxTotalConnectionPerRoute;
    private final Map<HttpRoute, Integer> maxTotalConnectionPerRoute;
    private final CredentialsProvider credentialsProvider;
    private final LayeredConnectionSocketFactory sslSocketFactory;
    private final ConnectionSocketFactory plainSocketFactory;
    private final HttpRoutePlanner httpRoutePlanner;
    private final AuthenticationStrategy proxyAuthenticationStrategy;
    private final SchemeIOSessionStrategy httpIOSessionStrategy;
    private final SchemeIOSessionStrategy httpsIOSessionStrategy;
    private final JestRetryHandler<HttpUriRequest> retryHandler;
    private Set<HttpHost> preemptiveAuthTargetHosts;

    public HttpClientConfig(Builder builder) {
        super(builder);
        this.maxTotalConnection = builder.maxTotalConnection;
        this.defaultMaxTotalConnectionPerRoute = builder.defaultMaxTotalConnectionPerRoute;
        this.maxTotalConnectionPerRoute = builder.maxTotalConnectionPerRoute;
        this.credentialsProvider = builder.credentialsProvider;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.plainSocketFactory = builder.plainSocketFactory;
        this.httpRoutePlanner = builder.httpRoutePlanner;
        this.proxyAuthenticationStrategy = builder.proxyAuthenticationStrategy;
        this.httpIOSessionStrategy = builder.httpIOSessionStrategy;
        this.httpsIOSessionStrategy = builder.httpsIOSessionStrategy;
        this.retryHandler = builder.retryHandler;
        this.preemptiveAuthTargetHosts = builder.preemptiveAuthTargetHosts;
    }

    public Map<HttpRoute, Integer> getMaxTotalConnectionPerRoute() {
        return this.maxTotalConnectionPerRoute;
    }

    public Integer getMaxTotalConnection() {
        return this.maxTotalConnection;
    }

    public Integer getDefaultMaxTotalConnectionPerRoute() {
        return this.defaultMaxTotalConnectionPerRoute;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public LayeredConnectionSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public ConnectionSocketFactory getPlainSocketFactory() {
        return this.plainSocketFactory;
    }

    public HttpRoutePlanner getHttpRoutePlanner() {
        return this.httpRoutePlanner;
    }

    public AuthenticationStrategy getProxyAuthenticationStrategy() {
        return this.proxyAuthenticationStrategy;
    }

    public SchemeIOSessionStrategy getHttpIOSessionStrategy() {
        return this.httpIOSessionStrategy;
    }

    public SchemeIOSessionStrategy getHttpsIOSessionStrategy() {
        return this.httpsIOSessionStrategy;
    }

    public JestRetryHandler<HttpUriRequest> getRetryHandler() {
        return this.retryHandler;
    }

    public Set<HttpHost> getPreemptiveAuthTargetHosts() {
        return this.preemptiveAuthTargetHosts;
    }

    public static class Builder
    extends ClientConfig.AbstractBuilder<HttpClientConfig, Builder> {
        private Integer maxTotalConnection;
        private Integer defaultMaxTotalConnectionPerRoute;
        private Map<HttpRoute, Integer> maxTotalConnectionPerRoute = new HashMap<HttpRoute, Integer>();
        private CredentialsProvider credentialsProvider;
        private LayeredConnectionSocketFactory sslSocketFactory;
        private ConnectionSocketFactory plainSocketFactory;
        private HttpRoutePlanner httpRoutePlanner;
        private AuthenticationStrategy proxyAuthenticationStrategy;
        private SchemeIOSessionStrategy httpIOSessionStrategy;
        private SchemeIOSessionStrategy httpsIOSessionStrategy;
        private JestRetryHandler<HttpUriRequest> retryHandler;
        private Set<HttpHost> preemptiveAuthTargetHosts = Collections.emptySet();

        public Builder(HttpClientConfig httpClientConfig) {
            super(httpClientConfig);
            this.maxTotalConnection = httpClientConfig.maxTotalConnection;
            this.defaultMaxTotalConnectionPerRoute = httpClientConfig.defaultMaxTotalConnectionPerRoute;
            this.maxTotalConnectionPerRoute = httpClientConfig.maxTotalConnectionPerRoute;
        }

        public Builder(Collection<String> serverUris) {
            super(serverUris);
        }

        public Builder(String serverUri) {
            super(serverUri);
        }

        @Override
        public Builder maxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
            return this;
        }

        @Override
        public Builder defaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
            return this;
        }

        public Builder maxTotalConnectionPerRoute(Map<HttpRoute, Integer> maxTotalConnectionPerRoute) {
            this.maxTotalConnectionPerRoute.putAll(maxTotalConnectionPerRoute);
            return this;
        }

        public Builder maxTotalConnectionPerRoute(HttpRoute httpRoute, int maxTotalConnection) {
            this.maxTotalConnectionPerRoute.put(httpRoute, maxTotalConnection);
            return this;
        }

        public Builder credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder defaultCredentials(String username, String password) {
            this.credentialsProvider = new BasicCredentialsProvider();
            this.credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
            return this;
        }

        public Builder sslSocketFactory(LayeredConnectionSocketFactory socketFactory) {
            this.sslSocketFactory = socketFactory;
            return this;
        }

        public Builder plainSocketFactory(ConnectionSocketFactory socketFactory) {
            this.plainSocketFactory = socketFactory;
            return this;
        }

        public Builder httpIOSessionStrategy(SchemeIOSessionStrategy httpIOSessionStrategy) {
            this.httpIOSessionStrategy = httpIOSessionStrategy;
            return this;
        }

        public Builder httpsIOSessionStrategy(SchemeIOSessionStrategy httpsIOSessionStrategy) {
            this.httpsIOSessionStrategy = httpsIOSessionStrategy;
            return this;
        }

        public Builder retryHandler(JestRetryHandler<HttpUriRequest> retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public Builder setPreemptiveAuth(HttpHost targetHost) {
            return this.preemptiveAuthTargetHosts(Collections.singleton(targetHost));
        }

        public Builder preemptiveAuthTargetHosts(Set<HttpHost> preemptiveAuthTargetHosts) {
            if (preemptiveAuthTargetHosts != null) {
                this.preemptiveAuthTargetHosts = new HashSet<HttpHost>(preemptiveAuthTargetHosts);
            }
            return this;
        }

        public Builder proxy(HttpHost proxy) {
            return this.proxy(proxy, null);
        }

        public Builder proxy(HttpHost proxy, AuthenticationStrategy proxyAuthenticationStrategy) {
            this.httpRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            this.proxyAuthenticationStrategy = proxyAuthenticationStrategy;
            return this;
        }

        @Override
        public HttpClientConfig build() {
            if (this.sslSocketFactory == null) {
                this.sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
            }
            if (this.plainSocketFactory == null) {
                this.plainSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
            }
            if (this.httpRoutePlanner == null) {
                this.httpRoutePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            }
            if (this.httpIOSessionStrategy == null) {
                this.httpIOSessionStrategy = NoopIOSessionStrategy.INSTANCE;
            }
            if (this.httpsIOSessionStrategy == null) {
                this.httpsIOSessionStrategy = SSLIOSessionStrategy.getSystemDefaultStrategy();
            }
            if (this.retryHandler == null) {
                this.retryHandler = new NoopRetryHandler<HttpUriRequest>();
            }
            if (this.preemptiveAuthSetWithoutCredentials()) {
                throw new IllegalArgumentException("Preemptive authentication set without credentials provider");
            }
            return new HttpClientConfig(this);
        }

        private boolean preemptiveAuthSetWithoutCredentials() {
            return !this.preemptiveAuthTargetHosts.isEmpty() && this.credentialsProvider == null;
        }
    }
}

