/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.core.CatResult;
import java.io.IOException;

public class Cat
extends AbstractAction<CatResult> {
    private static final String PATH_TO_RESULT = "result";
    private final String operationPath;

    protected <T extends AbstractAction.Builder<Cat, ? extends AbstractAction.Builder>> Cat(T builder) {
        super(builder);
        this.operationPath = ((CatBuilder)((Object)builder)).operationPath();
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        String uriSuffix = super.buildURI();
        return "_cat/" + this.operationPath + (uriSuffix.isEmpty() ? "" : "/") + uriSuffix;
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    @Override
    public String getPathToResult() {
        return PATH_TO_RESULT;
    }

    @Override
    public CatResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, ObjectMapper objectMapper) throws IOException {
        return this.createNewElasticSearchResult(new CatResult(objectMapper), responseBody, statusCode, reasonPhrase, objectMapper);
    }

    @Override
    protected ObjectNode parseResponseBody(String responseBody, ObjectMapper objectMapper) throws IOException {
        if (responseBody == null || responseBody.trim().isEmpty()) {
            return objectMapper.createObjectNode();
        }
        JsonNode parsed = objectMapper.readTree(responseBody);
        if (parsed.isArray()) {
            ObjectNode result = objectMapper.createObjectNode();
            result.set(PATH_TO_RESULT, parsed);
            return result;
        }
        throw new IllegalArgumentException("Cat response did not contain a JSON Array");
    }

    protected static interface CatBuilder {
        public String operationPath();
    }

    public static class NodesBuilder
    extends AbstractAction.Builder<Cat, NodesBuilder>
    implements CatBuilder {
        private static final String operationPath = "nodes";

        public NodesBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }

    public static class ShardsBuilder
    extends AbstractMultiIndexActionBuilder<Cat, ShardsBuilder>
    implements CatBuilder {
        private static final String operationPath = "shards";

        public ShardsBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }

        @Override
        public String getJoinedIndices() {
            if (this.indexNames.size() > 0) {
                return Joiner.on((char)',').join((Iterable)this.indexNames);
            }
            return null;
        }
    }

    public static class AliasesBuilder
    extends AbstractMultiIndexActionBuilder<Cat, AliasesBuilder>
    implements CatBuilder {
        private static final String operationPath = "aliases";

        public AliasesBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }

    public static class IndicesBuilder
    extends AbstractMultiTypeActionBuilder<Cat, IndicesBuilder>
    implements CatBuilder {
        private static final String operationPath = "indices";

        public IndicesBuilder() {
            this.setHeader("accept", "application/json");
            this.setHeader("content-type", "application/json");
        }

        @Override
        public Cat build() {
            return new Cat(this);
        }

        @Override
        public String operationPath() {
            return operationPath;
        }
    }
}

