/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntDoubleHashMap;

public class IntDoubleScatterMap
extends IntDoubleHashMap {
    public IntDoubleScatterMap() {
        this(4);
    }

    public IntDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntDoubleScatterMap from(int[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntDoubleScatterMap map = new IntDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

