/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.CollapsingDocValuesSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;

public abstract class CollapsingTopDocsCollector<T>
extends FirstPassGroupingCollector<T> {
    protected final String collapseField;
    protected final Sort sort;
    protected Scorer scorer;
    private int totalHitCount;
    private float maxScore;
    private final boolean trackMaxScore;

    private CollapsingTopDocsCollector(String collapseField, Sort sort, int topN, boolean trackMaxScore) throws IOException {
        super(sort, topN);
        this.collapseField = collapseField;
        this.trackMaxScore = trackMaxScore;
        this.maxScore = trackMaxScore ? Float.NEGATIVE_INFINITY : Float.NaN;
        this.sort = sort;
    }

    public CollapseTopFieldDocs getTopDocs() {
        Collection groups = super.getTopGroups(0, true);
        if (groups == null) {
            return new CollapseTopFieldDocs(this.collapseField, this.totalHitCount, new ScoreDoc[0], this.sort.getSort(), new Object[0], Float.NaN);
        }
        ScoreDoc[] docs = new FieldDoc[groups.size()];
        Object[] collapseValues = new Object[groups.size()];
        int scorePos = -1;
        for (int index = 0; index < this.sort.getSort().length; ++index) {
            SortField sortField = this.sort.getSort()[index];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            scorePos = index;
            break;
        }
        int pos = 0;
        Iterator it = this.orderedGroups.iterator();
        for (SearchGroup group : groups) {
            assert (it.hasNext());
            CollectedSearchGroup col = (CollectedSearchGroup)it.next();
            float score = Float.NaN;
            if (scorePos != -1) {
                score = ((Float)group.sortValues[scorePos]).floatValue();
            }
            docs[pos] = new FieldDoc(col.topDoc, score, group.sortValues);
            collapseValues[pos] = group.groupValue;
            ++pos;
        }
        return new CollapseTopFieldDocs(this.collapseField, this.totalHitCount, docs, this.sort.getSort(), collapseValues, this.maxScore);
    }

    @Override
    public boolean needsScores() {
        if (!super.needsScores()) {
            return this.trackMaxScore;
        }
        return true;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        super.setScorer(scorer);
        this.scorer = scorer;
    }

    @Override
    public void collect(int doc) throws IOException {
        super.collect(doc);
        if (this.trackMaxScore) {
            this.maxScore = Math.max(this.maxScore, this.scorer.score());
        }
        ++this.totalHitCount;
    }

    public static CollapsingTopDocsCollector<?> createNumeric(String collapseField, Sort sort, int topN, boolean trackMaxScore) throws IOException {
        return new Numeric(collapseField, sort, topN, trackMaxScore);
    }

    public static CollapsingTopDocsCollector<?> createKeyword(String collapseField, Sort sort, int topN, boolean trackMaxScore) throws IOException {
        return new Keyword(collapseField, sort, topN, trackMaxScore);
    }

    private static class Keyword
    extends CollapsingTopDocsCollector<BytesRef> {
        private final CollapsingDocValuesSource.Keyword source;

        private Keyword(String collapseField, Sort sort, int topN, boolean trackMaxScore) throws IOException {
            super(collapseField, sort, topN, trackMaxScore);
            this.source = new CollapsingDocValuesSource.Keyword(collapseField);
        }

        @Override
        protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
            super.doSetNextReader(readerContext);
            this.source.setNextReader(readerContext.reader());
        }

        @Override
        protected BytesRef getDocGroupValue(int doc) {
            return this.source.get(doc);
        }

        @Override
        protected BytesRef copyDocGroupValue(BytesRef groupValue, BytesRef reuse) {
            return this.source.copy(groupValue, reuse);
        }
    }

    private static class Numeric
    extends CollapsingTopDocsCollector<Long> {
        private final CollapsingDocValuesSource.Numeric source;

        private Numeric(String collapseField, Sort sort, int topN, boolean trackMaxScore) throws IOException {
            super(collapseField, sort, topN, trackMaxScore);
            this.source = new CollapsingDocValuesSource.Numeric(collapseField);
        }

        @Override
        protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
            super.doSetNextReader(readerContext);
            this.source.setNextReader(readerContext.reader());
        }

        @Override
        protected Long getDocGroupValue(int doc) {
            return this.source.get(doc);
        }

        @Override
        protected Long copyDocGroupValue(Long groupValue, Long reuse) {
            return this.source.copy(groupValue, reuse);
        }
    }
}

