/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.Polygon;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DPointOutsideSortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DPointSortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoCircle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoPath;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.PlanetModel;

public class Geo3DDocValuesField
extends Field {
    private static final double inverseMaximumValue = 4.768373855769089E-7;
    private static final double inverseXFactor = (PlanetModel.WGS84.getMaximumXValue() - PlanetModel.WGS84.getMinimumXValue()) * 4.768373855769089E-7;
    private static final double inverseYFactor = (PlanetModel.WGS84.getMaximumYValue() - PlanetModel.WGS84.getMinimumYValue()) * 4.768373855769089E-7;
    private static final double inverseZFactor = (PlanetModel.WGS84.getMaximumZValue() - PlanetModel.WGS84.getMinimumZValue()) * 4.768373855769089E-7;
    private static final double xFactor = 1.0 / inverseXFactor;
    private static final double yFactor = 1.0 / inverseYFactor;
    private static final double zFactor = 1.0 / inverseZFactor;
    private static final double STEP_FUDGE = 10.0;
    private static final double xStep = inverseXFactor * 10.0;
    private static final double yStep = inverseYFactor * 10.0;
    private static final double zStep = inverseZFactor * 10.0;
    public static final FieldType TYPE = new FieldType();

    public Geo3DDocValuesField(String name, GeoPoint point) {
        super(name, TYPE);
        this.setLocationValue(point);
    }

    public Geo3DDocValuesField(String name, double x, double y, double z) {
        super(name, TYPE);
        this.setLocationValue(x, y, z);
    }

    public void setLocationValue(GeoPoint point) {
        this.fieldsData = Geo3DDocValuesField.encodePoint(point);
    }

    public void setLocationValue(double x, double y, double z) {
        this.fieldsData = Geo3DDocValuesField.encodePoint(x, y, z);
    }

    public static long encodePoint(GeoPoint point) {
        return Geo3DDocValuesField.encodePoint(point.x, point.y, point.z);
    }

    public static long encodePoint(double x, double y, double z) {
        int XEncoded = Geo3DDocValuesField.encodeX(x);
        int YEncoded = Geo3DDocValuesField.encodeY(y);
        int ZEncoded = Geo3DDocValuesField.encodeZ(z);
        return (long)(XEncoded & 0x1FFFFF) << 42 | (long)(YEncoded & 0x1FFFFF) << 21 | (long)(ZEncoded & 0x1FFFFF);
    }

    public static GeoPoint decodePoint(long docValue) {
        return new GeoPoint(Geo3DDocValuesField.decodeX((int)(docValue >> 42) & 0x1FFFFF), Geo3DDocValuesField.decodeY((int)(docValue >> 21) & 0x1FFFFF), Geo3DDocValuesField.decodeZ((int)docValue & 0x1FFFFF));
    }

    public static double decodeXValue(long docValue) {
        return Geo3DDocValuesField.decodeX((int)(docValue >> 42) & 0x1FFFFF);
    }

    public static double decodeYValue(long docValue) {
        return Geo3DDocValuesField.decodeY((int)(docValue >> 21) & 0x1FFFFF);
    }

    public static double decodeZValue(long docValue) {
        return Geo3DDocValuesField.decodeZ((int)docValue & 0x1FFFFF);
    }

    public static double roundDownX(double startValue) {
        return startValue - xStep;
    }

    public static double roundUpX(double startValue) {
        return startValue + xStep;
    }

    public static double roundDownY(double startValue) {
        return startValue - yStep;
    }

    public static double roundUpY(double startValue) {
        return startValue + yStep;
    }

    public static double roundDownZ(double startValue) {
        return startValue - zStep;
    }

    public static double roundUpZ(double startValue) {
        return startValue + zStep;
    }

    private static int encodeX(double x) {
        if (x > PlanetModel.WGS84.getMaximumXValue()) {
            throw new IllegalArgumentException("x value exceeds WGS84 maximum");
        }
        if (x < PlanetModel.WGS84.getMinimumXValue()) {
            throw new IllegalArgumentException("x value less than WGS84 minimum");
        }
        return (int)Math.floor((x - PlanetModel.WGS84.getMinimumXValue()) * xFactor + 0.5);
    }

    private static double decodeX(int x) {
        return (double)x * inverseXFactor + PlanetModel.WGS84.getMinimumXValue();
    }

    private static int encodeY(double y) {
        if (y > PlanetModel.WGS84.getMaximumYValue()) {
            throw new IllegalArgumentException("y value exceeds WGS84 maximum");
        }
        if (y < PlanetModel.WGS84.getMinimumYValue()) {
            throw new IllegalArgumentException("y value less than WGS84 minimum");
        }
        return (int)Math.floor((y - PlanetModel.WGS84.getMinimumYValue()) * yFactor + 0.5);
    }

    private static double decodeY(int y) {
        return (double)y * inverseYFactor + PlanetModel.WGS84.getMinimumYValue();
    }

    private static int encodeZ(double z) {
        if (z > PlanetModel.WGS84.getMaximumZValue()) {
            throw new IllegalArgumentException("z value exceeds WGS84 maximum");
        }
        if (z < PlanetModel.WGS84.getMinimumZValue()) {
            throw new IllegalArgumentException("z value less than WGS84 minimum");
        }
        return (int)Math.floor((z - PlanetModel.WGS84.getMinimumZValue()) * zFactor + 0.5);
    }

    private static double decodeZ(int z) {
        return (double)z * inverseZFactor + PlanetModel.WGS84.getMinimumZValue();
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + (Object)((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + (Object)((Object)TYPE.docValuesType()) + ", is the field really a Geo3DDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(Geo3DDocValuesField.decodeXValue(currentValue));
        result.append(',');
        result.append(Geo3DDocValuesField.decodeYValue(currentValue));
        result.append(',');
        result.append(Geo3DDocValuesField.decodeZValue(currentValue));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, double latitude, double longitude, double maxRadiusMeters) {
        GeoCircle shape = Geo3DUtil.fromDistance(latitude, longitude, maxRadiusMeters);
        return new Geo3DPointSortField(field, shape);
    }

    public static SortField newPathSort(String field, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters) {
        GeoPath shape = Geo3DUtil.fromPath(pathLatitudes, pathLongitudes, pathWidthMeters);
        return new Geo3DPointSortField(field, shape);
    }

    public static SortField newOutsideDistanceSort(String field, double latitude, double longitude, double maxRadiusMeters) {
        GeoCircle shape = Geo3DUtil.fromDistance(latitude, longitude, maxRadiusMeters);
        return new Geo3DPointOutsideSortField(field, shape);
    }

    public static SortField newOutsideBoxSort(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoBBox shape = Geo3DUtil.fromBox(minLatitude, maxLatitude, minLongitude, maxLongitude);
        return new Geo3DPointOutsideSortField(field, shape);
    }

    public static SortField newOutsidePolygonSort(String field, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromPolygon(polygons);
        return new Geo3DPointOutsideSortField(field, shape);
    }

    public static SortField newOutsideLargePolygonSort(String field, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromLargePolygon(polygons);
        return new Geo3DPointOutsideSortField(field, shape);
    }

    public static SortField newOutsidePathSort(String field, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters) {
        GeoPath shape = Geo3DUtil.fromPath(pathLatitudes, pathLongitudes, pathWidthMeters);
        return new Geo3DPointOutsideSortField(field, shape);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

