/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.PointInShapeIntersectVisitor;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.BasePlanetObject;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.XYZBounds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.DocIdSetBuilder;

final class PointInGeo3DShapeQuery
extends Query {
    final String field;
    final GeoShape shape;
    final XYZBounds shapeBounds;

    public PointInGeo3DShapeQuery(String field, GeoShape shape) {
        BasePlanetObject planetObject;
        this.field = field;
        this.shape = shape;
        this.shapeBounds = new XYZBounds();
        shape.getBounds(this.shapeBounds);
        if (shape instanceof BasePlanetObject && !(planetObject = (BasePlanetObject)((Object)shape)).getPlanetModel().equals(PlanetModel.WGS84)) {
            throw new IllegalArgumentException("this qurey requires PlanetModel.WGS84, but got: " + planetObject.getPlanetModel());
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, PointInGeo3DShapeQuery.this.field);
                values.intersect(PointInGeo3DShapeQuery.this.field, new PointInShapeIntersectVisitor(result, PointInGeo3DShapeQuery.this.shape, PointInGeo3DShapeQuery.this.shapeBounds));
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public GeoShape getShape() {
        return this.shape;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInGeo3DShapeQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PointInGeo3DShapeQuery other) {
        return this.field.equals(other.field) && this.shape.equals(other.shape);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.shape.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(" Shape: ");
        sb.append(this.shape);
        return sb.toString();
    }
}

