/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoDegenerateHorizontalLine;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoDegenerateLatitudeZone;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoDegenerateLongitudeSlice;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoDegeneratePoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoDegenerateVerticalLine;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoLatitudeZone;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoLongitudeSlice;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoNorthLatitudeZone;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoNorthRectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoRectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoSouthLatitudeZone;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoSouthRectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoWideDegenerateHorizontalLine;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoWideLongitudeSlice;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoWideNorthRectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoWideRectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoWideSouthRectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoWorld;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.PlanetModel;

public class GeoBBoxFactory {
    private GeoBBoxFactory() {
    }

    public static GeoBBox makeGeoBBox(PlanetModel planetModel, double topLat, double bottomLat, double leftLon, double rightLon) {
        if (topLat > 1.5707963267948966) {
            topLat = 1.5707963267948966;
        }
        if (bottomLat < -1.5707963267948966) {
            bottomLat = -1.5707963267948966;
        }
        if (leftLon < -Math.PI) {
            leftLon = -Math.PI;
        }
        if (rightLon > Math.PI) {
            rightLon = Math.PI;
        }
        if (Math.abs(leftLon + Math.PI) < 3.141592653589793E-12 && Math.abs(rightLon - Math.PI) < 3.141592653589793E-12 || Math.abs(rightLon + Math.PI) < 3.141592653589793E-12 && Math.abs(leftLon - Math.PI) < 3.141592653589793E-12) {
            if (Math.abs(topLat - 1.5707963267948966) < 3.141592653589793E-12 && Math.abs(bottomLat + 1.5707963267948966) < 3.141592653589793E-12) {
                return new GeoWorld(planetModel);
            }
            if (Math.abs(topLat - bottomLat) < 3.141592653589793E-12) {
                if (Math.abs(topLat - 1.5707963267948966) < 3.141592653589793E-12 || Math.abs(topLat + 1.5707963267948966) < 3.141592653589793E-12) {
                    return new GeoDegeneratePoint(planetModel, topLat, 0.0);
                }
                return new GeoDegenerateLatitudeZone(planetModel, topLat);
            }
            if (Math.abs(topLat - 1.5707963267948966) < 3.141592653589793E-12) {
                return new GeoNorthLatitudeZone(planetModel, bottomLat);
            }
            if (Math.abs(bottomLat + 1.5707963267948966) < 3.141592653589793E-12) {
                return new GeoSouthLatitudeZone(planetModel, topLat);
            }
            return new GeoLatitudeZone(planetModel, topLat, bottomLat);
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (topLat == 1.5707963267948966 && bottomLat == -1.5707963267948966) {
            if (Math.abs(leftLon - rightLon) < 3.141592653589793E-12) {
                return new GeoDegenerateLongitudeSlice(planetModel, leftLon);
            }
            if (extent >= Math.PI) {
                return new GeoWideLongitudeSlice(planetModel, leftLon, rightLon);
            }
            return new GeoLongitudeSlice(planetModel, leftLon, rightLon);
        }
        if (Math.abs(leftLon - rightLon) < 3.141592653589793E-12) {
            if (Math.abs(topLat - bottomLat) < 3.141592653589793E-12) {
                return new GeoDegeneratePoint(planetModel, topLat, leftLon);
            }
            return new GeoDegenerateVerticalLine(planetModel, topLat, bottomLat, leftLon);
        }
        if (extent >= Math.PI) {
            if (Math.abs(topLat - bottomLat) < 3.141592653589793E-12) {
                return new GeoWideDegenerateHorizontalLine(planetModel, topLat, leftLon, rightLon);
            }
            if (Math.abs(topLat - 1.5707963267948966) < 3.141592653589793E-12) {
                return new GeoWideNorthRectangle(planetModel, bottomLat, leftLon, rightLon);
            }
            if (Math.abs(bottomLat + 1.5707963267948966) < 3.141592653589793E-12) {
                return new GeoWideSouthRectangle(planetModel, topLat, leftLon, rightLon);
            }
            return new GeoWideRectangle(planetModel, topLat, bottomLat, leftLon, rightLon);
        }
        if (Math.abs(topLat - bottomLat) < 3.141592653589793E-12) {
            if (Math.abs(topLat - 1.5707963267948966) < 3.141592653589793E-12 || Math.abs(topLat + 1.5707963267948966) < 3.141592653589793E-12) {
                return new GeoDegeneratePoint(planetModel, topLat, 0.0);
            }
            return new GeoDegenerateHorizontalLine(planetModel, topLat, leftLon, rightLon);
        }
        if (Math.abs(topLat - 1.5707963267948966) < 3.141592653589793E-12) {
            return new GeoNorthRectangle(planetModel, bottomLat, leftLon, rightLon);
        }
        if (Math.abs(bottomLat + 1.5707963267948966) < 3.141592653589793E-12) {
            return new GeoSouthRectangle(planetModel, topLat, leftLon, rightLon);
        }
        return new GeoRectangle(planetModel, topLat, bottomLat, leftLon, rightLon);
    }
}

