/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataUpdateSettingsService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportUpgradeSettingsAction
extends TransportMasterNodeAction<UpgradeSettingsRequest, UpgradeSettingsResponse> {
    private final MetaDataUpdateSettingsService updateSettingsService;

    @Inject
    public TransportUpgradeSettingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataUpdateSettingsService updateSettingsService, IndexNameExpressionResolver indexNameExpressionResolver, ActionFilters actionFilters) {
        super(settings, "internal:indices/admin/upgrade", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, UpgradeSettingsRequest::new);
        this.updateSettingsService = updateSettingsService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(UpgradeSettingsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected UpgradeSettingsResponse newResponse() {
        return new UpgradeSettingsResponse();
    }

    @Override
    protected void masterOperation(final UpgradeSettingsRequest request, ClusterState state, final ActionListener<UpgradeSettingsResponse> listener) {
        UpgradeSettingsClusterStateUpdateRequest clusterStateUpdateRequest = (UpgradeSettingsClusterStateUpdateRequest)((UpgradeSettingsClusterStateUpdateRequest)new UpgradeSettingsClusterStateUpdateRequest().ackTimeout(request.timeout())).versions(request.versions()).masterNodeTimeout(request.masterNodeTimeout());
        this.updateSettingsService.upgradeIndexSettings(clusterStateUpdateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new UpgradeSettingsResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Exception t) {
                TransportUpgradeSettingsAction.this.logger.debug(() -> new ParameterizedMessage("failed to upgrade minimum compatibility version settings on indices [{}]", request.versions().keySet()), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }
}

