/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Streamable;

public class QueryExplanation
implements Streamable {
    public static final int RANDOM_SHARD = -1;
    private String index;
    private int shard = -1;
    private boolean valid;
    private String explanation;
    private String error;

    QueryExplanation() {
    }

    public QueryExplanation(String index, int shard, boolean valid, String explanation, String error) {
        this.index = index;
        this.shard = shard;
        this.valid = valid;
        this.explanation = explanation;
        this.error = error;
    }

    public String getIndex() {
        return this.index;
    }

    public int getShard() {
        return this.shard;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getError() {
        return this.error;
    }

    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shard = in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readInt() : -1;
        this.valid = in.readBoolean();
        this.explanation = in.readOptionalString();
        this.error = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
            out.writeInt(this.shard);
        }
        out.writeBoolean(this.valid);
        out.writeOptionalString(this.explanation);
        out.writeOptionalString(this.error);
    }

    public static QueryExplanation readQueryExplanation(StreamInput in) throws IOException {
        QueryExplanation exp = new QueryExplanation();
        exp.readFrom(in);
        return exp;
    }
}

