/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;

public class IndexConstraint {
    private final String field;
    private final Property property;
    private final Comparison comparison;
    private final String value;
    private final String optionalFormat;

    IndexConstraint(StreamInput input) throws IOException {
        this.field = input.readString();
        this.property = Property.read(input.readByte());
        this.comparison = Comparison.read(input.readByte());
        this.value = input.readString();
        this.optionalFormat = input.getVersion().onOrAfter(Version.V_2_0_1) ? input.readOptionalString() : null;
    }

    public IndexConstraint(String field, Property property, Comparison comparison, String value) {
        this(field, property, comparison, value, null);
    }

    public IndexConstraint(String field, Property property, Comparison comparison, String value, String optionalFormat) {
        this.field = Objects.requireNonNull(field);
        this.property = Objects.requireNonNull(property);
        this.comparison = Objects.requireNonNull(comparison);
        this.value = Objects.requireNonNull(value);
        this.optionalFormat = optionalFormat;
    }

    public String getField() {
        return this.field;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public Property getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public String getOptionalFormat() {
        return this.optionalFormat;
    }

    public static enum Comparison {
        LT(0),
        LTE(1),
        GT(2),
        GTE(3);

        private final byte id;

        private Comparison(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static Comparison read(byte id) {
            switch (id) {
                case 0: {
                    return LT;
                }
                case 1: {
                    return LTE;
                }
                case 2: {
                    return GT;
                }
                case 3: {
                    return GTE;
                }
            }
            throw new IllegalArgumentException("Unknown comparison [" + id + "]");
        }

        public static Comparison parse(String value) {
            switch (value = value.toLowerCase(Locale.ROOT)) {
                case "lt": {
                    return LT;
                }
                case "lte": {
                    return LTE;
                }
                case "gt": {
                    return GT;
                }
                case "gte": {
                    return GTE;
                }
            }
            throw new IllegalArgumentException("Unknown comparison [" + value + "]");
        }
    }

    public static enum Property {
        MIN(0),
        MAX(1);

        private final byte id;

        private Property(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static Property read(byte id) {
            switch (id) {
                case 0: {
                    return MIN;
                }
                case 1: {
                    return MAX;
                }
            }
            throw new IllegalArgumentException("Unknown property [" + id + "]");
        }

        public static Property parse(String value) {
            switch (value = value.toLowerCase(Locale.ROOT)) {
                case "min_value": {
                    return MIN;
                }
                case "max_value": {
                    return MAX;
                }
            }
            throw new IllegalArgumentException("Unknown property [" + value + "]");
        }
    }
}

