/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ack.AckedRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;

public abstract class AcknowledgedRequest<Request extends MasterNodeRequest<Request>>
extends MasterNodeRequest<Request>
implements AckedRequest {
    public static final TimeValue DEFAULT_ACK_TIMEOUT = TimeValue.timeValueSeconds(30L);
    protected TimeValue timeout = DEFAULT_ACK_TIMEOUT;

    protected AcknowledgedRequest() {
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, this.timeout, this.getClass().getSimpleName() + ".timeout");
        return (Request)this;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final TimeValue timeout() {
        return this.timeout;
    }

    @Deprecated
    protected void readTimeout(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_5_6_0)) {
            this.timeout = new TimeValue(in);
        }
    }

    @Deprecated
    protected void writeTimeout(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_5_6_0)) {
            this.timeout.writeTo(out);
        }
    }

    @Override
    public TimeValue ackTimeout() {
        return this.timeout;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.timeout = new TimeValue(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.timeout.writeTo(out);
        }
    }
}

