/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;

public abstract class SingleShardRequest<Request extends SingleShardRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    @Nullable
    protected String index;
    ShardId internalShardId;
    private boolean threadedOperation = true;

    public SingleShardRequest() {
    }

    protected SingleShardRequest(String index) {
        this.index = index;
    }

    protected ActionRequestValidationException validateNonNullIndex() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return INDICES_OPTIONS;
    }

    public boolean operationThreaded() {
        return this.threadedOperation;
    }

    public final Request operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return (Request)this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.internalShardId = ShardId.readShardId(in);
        }
        this.index = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable(this.internalShardId);
        out.writeOptionalString(this.index);
    }
}

