/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap;

import java.io.IOException;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Arrays;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSpec;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSpecBuilder;
import org.graylog.shaded.elasticsearch5.joptsimple.util.PathConverter;
import org.graylog.shaded.elasticsearch5.joptsimple.util.PathProperties;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Build;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap.Bootstrap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap.BootstrapException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap.StartupException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.UserException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.LogConfigurator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.monitor.jvm.JvmInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.NodeValidationException;

class Elasticsearch
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;

    Elasticsearch() {
        super("starts elasticsearch");
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints elasticsearch version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts Elasticsearch in the background").availableUnless(this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless(this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard ouput/error streams logging in console").availableUnless(this.versionOption, new OptionSpec[0]).availableUnless(this.daemonizeOption, new OptionSpec[0]);
    }

    public static void main(String[] args) throws Exception {
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        LogConfigurator.registerErrorListener();
        Elasticsearch elasticsearch = new Elasticsearch();
        int status = Elasticsearch.main(args, elasticsearch, Terminal.DEFAULT);
        if (status != 0) {
            Elasticsearch.exit(status);
        }
    }

    static int main(String[] args, Elasticsearch elasticsearch, Terminal terminal) throws Exception {
        return elasticsearch.main(args, terminal);
    }

    @Override
    protected boolean shouldConfigureLoggingWithoutConfig() {
        return false;
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws UserException {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + options.nonOptionArguments());
        }
        if (options.has(this.versionOption)) {
            if (options.has(this.daemonizeOption) || options.has(this.pidfileOption)) {
                throw new UserException(64, "Elasticsearch version option is mutually exclusive with any other option");
            }
            terminal.println("Version: " + Version.CURRENT + ", Build: " + Build.CURRENT.shortHash() + "/" + Build.CURRENT.date() + ", JVM: " + JvmInfo.jvmInfo().version());
            return;
        }
        boolean daemonize = options.has(this.daemonizeOption);
        Path pidFile = this.pidfileOption.value(options);
        boolean quiet = options.has(this.quietOption);
        try {
            this.init(daemonize, pidFile, quiet, env);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) throws NodeValidationException, UserException {
        try {
            Bootstrap.init(!daemonize, pidFile, quiet, initialEnv);
        }
        catch (RuntimeException | BootstrapException e) {
            throw new StartupException(e);
        }
    }

    static void close(String[] args) throws IOException {
        Bootstrap.stop();
    }
}

