/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node;

import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.Action;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.GenericAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.TransportAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.support.AbstractClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public class NodeClient
extends AbstractClient {
    private Map<GenericAction, TransportAction> actions;
    private Supplier<String> localNodeId;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<GenericAction, TransportAction> actions, Supplier<String> localNodeId) {
        this.actions = actions;
        this.localNodeId = localNodeId;
    }

    @Override
    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(GenericAction<Request, Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(GenericAction<Request, Response> action, Request request, TaskListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(GenericAction<Request, Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }
}

