/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RecoverySource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_version";

    public NodeVersionAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            if (shardRouting.currentNodeId() == null) {
                if (shardRouting.recoverySource() != null && shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
                    return this.isVersionCompatible((RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource(), node, allocation);
                }
                return allocation.decision(Decision.YES, NAME, "the primary shard is new or already existed on the node", new Object[0]);
            }
            return this.isVersionCompatible(allocation.routingNodes(), shardRouting.currentNodeId(), node, allocation);
        }
        ShardRouting primary = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primary != null) {
            return this.isVersionCompatible(allocation.routingNodes(), primary.currentNodeId(), node, allocation);
        }
        return allocation.decision(Decision.YES, NAME, "no active primary shard yet", new Object[0]);
    }

    private Decision isVersionCompatible(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getVersion().onOrAfter(source.node().getVersion())) {
            return allocation.decision(Decision.YES, NAME, "target node version [%s] is the same or newer than source node version [%s]", target.node().getVersion(), source.node().getVersion());
        }
        return allocation.decision(Decision.NO, NAME, "target node version [%s] is older than the source node version [%s]", target.node().getVersion(), source.node().getVersion());
    }

    private Decision isVersionCompatible(RecoverySource.SnapshotRecoverySource recoverySource, RoutingNode target, RoutingAllocation allocation) {
        if (target.node().getVersion().onOrAfter(recoverySource.version())) {
            return allocation.decision(Decision.YES, NAME, "target node version [%s] is the same or newer than snapshot version [%s]", target.node().getVersion(), recoverySource.version());
        }
        return allocation.decision(Decision.NO, NAME, "target node version [%s] is older than the snapshot version [%s]", target.node().getVersion(), recoverySource.version());
    }
}

