/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.uid.VersionsResolver;

final class PerThreadIDAndVersionLookup {
    final String uidField;
    private final TermsEnum termsEnum;
    private final NumericDocValues versions;
    private PostingsEnum docsEnum;
    private final Object readerKey;

    PerThreadIDAndVersionLookup(LeafReader reader, String uidField) throws IOException {
        this.uidField = uidField;
        Fields fields = reader.fields();
        Terms terms = fields.terms(uidField);
        if (terms == null) {
            throw new IllegalArgumentException("reader misses the [" + uidField + "] field");
        }
        this.termsEnum = terms.iterator();
        this.versions = reader.getNumericDocValues("_version");
        if (this.versions == null) {
            throw new IllegalArgumentException("reader misses the [_version] field");
        }
        Object readerKey = null;
        assert ((readerKey = reader.getCoreCacheKey()) != null);
        this.readerKey = readerKey;
    }

    public VersionsResolver.DocIdAndVersion lookupVersion(BytesRef id, Bits liveDocs, LeafReaderContext context) throws IOException {
        assert (context.reader().getCoreCacheKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        int docID = this.getDocID(id, liveDocs);
        if (docID != Integer.MAX_VALUE) {
            return new VersionsResolver.DocIdAndVersion(docID, this.versions.get(docID), context);
        }
        return null;
    }

    private int getDocID(BytesRef id, Bits liveDocs) throws IOException {
        if (this.termsEnum.seekExact(id)) {
            int docID = Integer.MAX_VALUE;
            this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
            int d = this.docsEnum.nextDoc();
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    docID = d;
                }
                d = this.docsEnum.nextDoc();
            }
            return docID;
        }
        return Integer.MAX_VALUE;
    }
}

