/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.network;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.network.InetAddresses;

public final class NetworkAddress {
    private NetworkAddress() {
    }

    public static String format(InetAddress address) {
        return NetworkAddress.format(address, -1);
    }

    public static String format(InetSocketAddress address) {
        return NetworkAddress.format(address.getAddress(), address.getPort());
    }

    static String format(InetAddress address, int port) {
        Objects.requireNonNull(address);
        StringBuilder builder = new StringBuilder();
        if (port != -1 && address instanceof Inet6Address) {
            builder.append(InetAddresses.toUriString(address));
        } else {
            builder.append(InetAddresses.toAddrString(address));
        }
        if (port != -1) {
            builder.append(':');
            builder.append(port);
        }
        return builder.toString();
    }
}

