/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.single;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Priority;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.Discovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.DiscoverySettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.DiscoveryStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.zen.PendingClusterStateStats;

public class SingleNodeDiscovery
extends AbstractLifecycleComponent
implements Discovery {
    private final ClusterService clusterService;
    private final DiscoverySettings discoverySettings;

    public SingleNodeDiscovery(Settings settings, ClusterService clusterService) {
        super(Objects.requireNonNull(settings));
        this.clusterService = Objects.requireNonNull(clusterService);
        ClusterSettings clusterSettings = Objects.requireNonNull(clusterService.getClusterSettings());
        this.discoverySettings = new DiscoverySettings(settings, clusterSettings);
    }

    @Override
    public DiscoveryNode localNode() {
        return this.clusterService.localNode();
    }

    @Override
    public String nodeDescription() {
        return this.clusterService.getClusterName().value() + "/" + this.clusterService.localNode().getId();
    }

    @Override
    public void setAllocationService(AllocationService allocationService) {
    }

    @Override
    public void publish(ClusterChangedEvent event, Discovery.AckListener listener) {
    }

    @Override
    public DiscoveryStats stats() {
        return new DiscoveryStats((PendingClusterStateStats)null);
    }

    @Override
    public DiscoverySettings getDiscoverySettings() {
        return this.discoverySettings;
    }

    @Override
    public void startInitialJoin() {
        ClusterStateTaskExecutor<DiscoveryNode> executor = new ClusterStateTaskExecutor<DiscoveryNode>(){

            @Override
            public ClusterStateTaskExecutor.ClusterTasksResult<DiscoveryNode> execute(ClusterState current, List<DiscoveryNode> tasks) throws Exception {
                assert (tasks.size() == 1);
                DiscoveryNodes.Builder nodes = DiscoveryNodes.builder(current.nodes());
                nodes.masterNodeId(SingleNodeDiscovery.this.localNode().getId());
                ClusterState next = ClusterState.builder(current).nodes(nodes).build();
                ClusterStateTaskExecutor.ClusterTasksResult.Builder<DiscoveryNode> result = ClusterStateTaskExecutor.ClusterTasksResult.builder();
                return result.successes(tasks).build(next);
            }

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }
        };
        ClusterStateTaskConfig config = ClusterStateTaskConfig.build(Priority.URGENT);
        this.clusterService.submitStateUpdateTasks("single-node-start-initial-join", Collections.singletonMap(this.localNode(), (s, e) -> {}), config, executor);
    }

    @Override
    public int getMinimumMasterNodes() {
        return 1;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }
}

