/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AnalyzerScope;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PreBuiltAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis.AnalysisModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis.PreBuiltAnalyzers;

public class PreBuiltAnalyzerProviderFactory
implements AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> {
    private final PreBuiltAnalyzerProvider analyzerProvider;

    public PreBuiltAnalyzerProviderFactory(String name, AnalyzerScope scope, Analyzer analyzer) {
        this.analyzerProvider = new PreBuiltAnalyzerProvider(name, scope, analyzer);
    }

    public AnalyzerProvider<?> create(String name, Settings settings) {
        PreBuiltAnalyzers preBuiltAnalyzers;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltAnalyzers = PreBuiltAnalyzers.getOrDefault(name, null)) != null) {
            Analyzer analyzer = preBuiltAnalyzers.getAnalyzer(indexVersion);
            return new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, analyzer);
        }
        return this.analyzerProvider;
    }

    @Override
    public AnalyzerProvider<?> get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        return this.create(name, settings);
    }

    public Analyzer analyzer() {
        return this.analyzerProvider.get();
    }
}

