/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.core.StopAnalyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.suggest.analyzing.SuggestStopFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.Analysis;

public class StopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet stopWords;
    private final boolean ignoreCase;
    private final boolean removeTrailing;

    public StopTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", false);
        this.removeTrailing = settings.getAsBoolean("remove_trailing", true);
        this.stopWords = Analysis.parseStopWords(env, settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        if (settings.get("enable_position_increments") != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain");
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.removeTrailing) {
            return new StopFilter(tokenStream, this.stopWords);
        }
        return new SuggestStopFilter(tokenStream, this.stopWords);
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }
}

