/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis;

import java.io.Reader;
import java.util.Locale;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CharFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltCharFilters {
    HTML_STRIP(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public Reader create(Reader tokenStream, Version version) {
            return new HTMLStripCharFilter(tokenStream);
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<CharFilterFactory> cache;

    public abstract Reader create(Reader var1, Version var2);

    private PreBuiltCharFilters(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized CharFilterFactory getCharFilterFactory(final Version version) {
        CharFilterFactory charFilterFactory = this.cache.get(version);
        if (charFilterFactory == null) {
            final String finalName = this.name();
            charFilterFactory = new CharFilterFactory(){

                @Override
                public String name() {
                    return finalName.toLowerCase(Locale.ROOT);
                }

                @Override
                public Reader create(Reader tokenStream) {
                    return PreBuiltCharFilters.valueOf(finalName).create(tokenStream, version);
                }
            };
            this.cache.put(version, charFilterFactory);
        }
        return charFilterFactory;
    }

    public static PreBuiltCharFilters getOrDefault(String name, PreBuiltCharFilters defaultCharFilter) {
        try {
            return PreBuiltCharFilters.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultCharFilter;
        }
    }
}

