/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.store.Store;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;

public class RecoveryCleanFilesRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private Store.MetadataSnapshot snapshotFiles;
    private int totalTranslogOps = -1;

    public RecoveryCleanFilesRequest() {
    }

    RecoveryCleanFilesRequest(long recoveryId, ShardId shardId, Store.MetadataSnapshot snapshotFiles, int totalTranslogOps) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.snapshotFiles = snapshotFiles;
        this.totalTranslogOps = totalTranslogOps;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.snapshotFiles = new Store.MetadataSnapshot(in);
        this.totalTranslogOps = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.snapshotFiles.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
    }

    public Store.MetadataSnapshot sourceMetaSnapshot() {
        return this.snapshotFiles;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }
}

