/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ResourceNotFoundException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.PutPipelineRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.WritePipelineResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateApplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ack.AckedRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway.GatewayService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.ConfigurationUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestMetadata;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.Pipeline;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.PipelineConfiguration;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.Processor;

public class PipelineStore
extends AbstractComponent
implements ClusterStateApplier {
    private final Pipeline.Factory factory = new Pipeline.Factory();
    private final Map<String, Processor.Factory> processorFactories;
    private volatile boolean newIngestDateFormat;
    volatile Map<String, Pipeline> pipelines = new HashMap<String, Pipeline>();

    public PipelineStore(ClusterSettings clusterSettings, Settings settings, Map<String, Processor.Factory> processorFactories) {
        super(settings);
        this.processorFactories = processorFactories;
        this.newIngestDateFormat = IngestService.NEW_INGEST_DATE_FORMAT.get(settings);
        clusterSettings.addSettingsUpdateConsumer(IngestService.NEW_INGEST_DATE_FORMAT, this::setNewIngestDateFormat);
    }

    private void setNewIngestDateFormat(Boolean newIngestDateFormat) {
        this.newIngestDateFormat = newIngestDateFormat;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.innerUpdatePipelines(event.previousState(), event.state());
    }

    void innerUpdatePipelines(ClusterState previousState, ClusterState state) {
        IngestMetadata previousIngestMetadata;
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)state.getMetaData().custom("ingest");
        if (Objects.equals(ingestMetadata, previousIngestMetadata = (IngestMetadata)previousState.getMetaData().custom("ingest"))) {
            return;
        }
        HashMap<String, Pipeline> pipelines = new HashMap<String, Pipeline>();
        for (PipelineConfiguration pipeline : ingestMetadata.getPipelines().values()) {
            try {
                pipelines.put(pipeline.getId(), this.factory.create(pipeline.getId(), pipeline.getConfigAsMap(), this.processorFactories));
            }
            catch (ElasticsearchParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("Error updating pipeline with id [" + pipeline.getId() + "]", (Throwable)e, new Object[0]);
            }
        }
        this.pipelines = Collections.unmodifiableMap(pipelines);
    }

    public void delete(ClusterService clusterService, final DeletePipelineRequest request, ActionListener<WritePipelineResponse> listener) {
        clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<WritePipelineResponse>((AckedRequest)request, listener){

            @Override
            protected WritePipelineResponse newResponse(boolean acknowledged) {
                return new WritePipelineResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return PipelineStore.this.innerDelete(request, currentState);
            }
        });
    }

    ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metaData().custom("ingest");
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty() && !Regex.isMatchAllPattern(request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        if (toRemove.isEmpty()) {
            return currentState;
        }
        HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            pipelinesCopy.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder(currentState);
        builder.metaData(MetaData.builder(currentState.getMetaData()).putCustom("ingest", new IngestMetadata(pipelinesCopy)).build());
        return builder.build();
    }

    public void put(ClusterService clusterService, Map<DiscoveryNode, IngestInfo> ingestInfos, final PutPipelineRequest request, ActionListener<WritePipelineResponse> listener) throws Exception {
        this.validatePipeline(ingestInfos, request);
        clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<WritePipelineResponse>((AckedRequest)request, listener){

            @Override
            protected WritePipelineResponse newResponse(boolean acknowledged) {
                return new WritePipelineResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return PipelineStore.this.innerPut(request, currentState);
            }
        });
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, PutPipelineRequest request) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Map<String, Object> pipelineConfig = XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        Pipeline pipeline = this.factory.create(request.getId(), pipelineConfig, this.processorFactories);
        ArrayList<ElasticsearchException> exceptions = new ArrayList<ElasticsearchException>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                if (entry.getValue().containsProcessor(processor.getType())) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + entry.getKey() + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metaData().custom("ingest");
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getXContentType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metaData(MetaData.builder(currentState.getMetaData()).putCustom("ingest", new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    public Pipeline get(String id) {
        return this.pipelines.get(id);
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    public boolean isNewIngestDateFormat() {
        return this.newIngestDateFormat;
    }

    public List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetaData().custom("ingest");
        return this.innerGetPipelines(ingestMetadata, ids);
    }

    List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }
}

