/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.cluster.RestListTasksAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskId;

public class RestCancelTasksAction
extends BaseRestHandler {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestCancelTasksAction(Settings settings, RestController controller, Supplier<DiscoveryNodes> nodesInCluster) {
        super(settings);
        this.nodesInCluster = nodesInCluster;
        controller.registerHandler(RestRequest.Method.POST, "/_tasks/_cancel", this);
        controller.registerHandler(RestRequest.Method.POST, "/_tasks/{task_id}/_cancel", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodes"));
        TaskId taskId = new TaskId(request.param("task_id"));
        String[] actions = Strings.splitStringByCommaToArray(request.param("actions"));
        TaskId parentTaskId = new TaskId(request.param("parent_task_id"));
        String groupBy = request.param("group_by", "nodes");
        CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
        cancelTasksRequest.setTaskId(taskId);
        cancelTasksRequest.setNodes(nodesIds);
        cancelTasksRequest.setActions(actions);
        cancelTasksRequest.setParentTaskId(parentTaskId);
        return channel -> client.admin().cluster().cancelTasks(cancelTasksRequest, RestListTasksAction.listTasksResponseListener(this.nodesInCluster, groupBy, channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

