/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Table;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestResponseListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat.RestTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;

public class RestCountAction
extends AbstractCatAction {
    public RestCountAction(Settings settings, RestController restController) {
        super(settings);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/count", this);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/count/{index}", this);
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/count\n");
        sb.append("/_cat/count/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        SearchRequest countRequest = new SearchRequest(indices);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0);
        countRequest.source(searchSourceBuilder);
        try {
            request.withContentOrSourceParamParserOrNull(parser -> {
                if (parser == null) {
                    QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
                    if (queryBuilder != null) {
                        searchSourceBuilder.query(queryBuilder);
                    }
                } else {
                    searchSourceBuilder.query(RestActions.getQueryContent(parser));
                }
            });
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't parse query", (Throwable)e, new Object[0]);
        }
        return channel -> client.search(countRequest, (ActionListener<SearchResponse>)new RestResponseListener<SearchResponse>(channel){

            @Override
            public RestResponse buildResponse(SearchResponse countResponse) throws Exception {
                return RestTable.buildResponse(RestCountAction.this.buildTable(request, countResponse), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeadersWithTimestamp();
        table.addCell("count", "alias:dc,docs.count,docsCount;desc:the document count");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, SearchResponse response) {
        Table table = this.getTableWithHeader(request);
        table.startRow();
        table.addCell(response.getHits().totalHits());
        table.endRow();
        return table;
    }
}

