/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Table;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestResponseListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat.RestTable;

public class RestRepositoriesAction
extends AbstractCatAction {
    public RestRepositoriesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/repositories", this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest();
        getRepositoriesRequest.local(request.paramAsBoolean("local", getRepositoriesRequest.local()));
        getRepositoriesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getRepositoriesRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().getRepositories(getRepositoriesRequest, (ActionListener<GetRepositoriesResponse>)new RestResponseListener<GetRepositoriesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetRepositoriesResponse getRepositoriesResponse) throws Exception {
                return RestTable.buildResponse(RestRepositoriesAction.this.buildTable(request, getRepositoriesResponse), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/repositories\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        return new Table().startHeaders().addCell("id", "alias:id,repoId;desc:unique repository id").addCell("type", "alias:t,type;text-align:right;desc:repository type").endHeaders();
    }

    private Table buildTable(RestRequest req, GetRepositoriesResponse getRepositoriesResponse) {
        Table table = this.getTableWithHeader(req);
        for (RepositoryMetaData repositoryMetaData : getRepositoriesResponse.repositories()) {
            table.startRow();
            table.addCell(repositoryMetaData.name());
            table.addCell(repositoryMetaData.type());
            table.endRow();
        }
        return table;
    }
}

