/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptEngineService;

public class ScriptEngineRegistry {
    private final Map<Class<? extends ScriptEngineService>, String> registeredScriptEngineServices;
    private final Map<String, ScriptEngineService> registeredLanguages;
    private final Map<String, Boolean> defaultInlineScriptEnableds;

    public ScriptEngineRegistry(Iterable<ScriptEngineService> registrations) {
        Objects.requireNonNull(registrations);
        HashMap registeredScriptEngineServices = new HashMap();
        HashMap<String, ScriptEngineService> registeredLanguages = new HashMap<String, ScriptEngineService>();
        HashMap<String, Boolean> inlineScriptEnableds = new HashMap<String, Boolean>();
        for (ScriptEngineService service : registrations) {
            String oldLanguage = registeredScriptEngineServices.putIfAbsent(service.getClass(), service.getType());
            if (oldLanguage != null) {
                throw new IllegalArgumentException("script engine service [" + service.getClass() + "] already registered for language [" + oldLanguage + "]");
            }
            String language = service.getType();
            ScriptEngineService scriptEngineService = registeredLanguages.putIfAbsent(language, service);
            if (scriptEngineService != null) {
                throw new IllegalArgumentException("scripting language [" + language + "] already registered for script engine service [" + scriptEngineService.getClass().getCanonicalName() + "]");
            }
            inlineScriptEnableds.put(language, service.isInlineScriptEnabled());
        }
        this.registeredScriptEngineServices = Collections.unmodifiableMap(registeredScriptEngineServices);
        this.registeredLanguages = Collections.unmodifiableMap(registeredLanguages);
        this.defaultInlineScriptEnableds = Collections.unmodifiableMap(inlineScriptEnableds);
    }

    Iterable<Class<? extends ScriptEngineService>> getRegisteredScriptEngineServices() {
        return this.registeredScriptEngineServices.keySet();
    }

    String getLanguage(Class<? extends ScriptEngineService> scriptEngineService) {
        Objects.requireNonNull(scriptEngineService);
        return this.registeredScriptEngineServices.get(scriptEngineService);
    }

    public Map<String, ScriptEngineService> getRegisteredLanguages() {
        return this.registeredLanguages;
    }

    public Map<String, Boolean> getDefaultInlineScriptEnableds() {
        return this.defaultInlineScriptEnableds;
    }
}

