/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.rounding.Rounding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.LongHash;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

class DateHistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final InternalOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final LongHash bucketOrds;
    private long offset;

    DateHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, long offset, InternalOrder order, boolean keyed, long minDocCount, @Nullable ExtendedBounds extendedBounds, @Nullable ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.rounding = rounding;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                values.setDocument(doc);
                int valuesCount = values.count();
                long previousRounded = Long.MIN_VALUE;
                for (int i = 0; i < valuesCount; ++i) {
                    long value = values.valueAt(i);
                    long rounded = DateHistogramAggregator.this.rounding.round(value - DateHistogramAggregator.this.offset) + DateHistogramAggregator.this.offset;
                    assert (rounded >= previousRounded);
                    if (rounded == previousRounded) continue;
                    long bucketOrd = DateHistogramAggregator.this.bucketOrds.add(rounded);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        DateHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                    } else {
                        DateHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                    }
                    previousRounded = rounded;
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        ArrayList<InternalDateHistogram.Bucket> buckets = new ArrayList<InternalDateHistogram.Bucket>((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            buckets.add(new InternalDateHistogram.Bucket(this.bucketOrds.get(i), this.bucketDocCount(i), this.keyed, this.formatter, this.bucketAggregations(i)));
        }
        CollectionUtil.introSort(buckets, InternalOrder.KEY_ASC.comparator());
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.offset, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.offset, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

