/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram;

import java.util.Comparator;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;

public interface Histogram
extends MultiBucketsAggregation {
    public static final ParseField INTERVAL_FIELD = new ParseField("interval", new String[0]);
    public static final ParseField OFFSET_FIELD = new ParseField("offset", new String[0]);
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD = new ParseField("min_doc_count", new String[0]);
    public static final ParseField EXTENDED_BOUNDS_FIELD = new ParseField("extended_bounds", new String[0]);

    public List<? extends Bucket> getBuckets();

    public static abstract class Order
    implements ToXContent {
        public static final Order KEY_ASC = new InternalOrder(1, "_key", true, new Comparator<Bucket>(){

            @Override
            public int compare(Bucket b1, Bucket b2) {
                return Order.compareKey(b1, b2);
            }
        });
        public static final Order KEY_DESC = new InternalOrder(2, "_key", false, new Comparator<Bucket>(){

            @Override
            public int compare(Bucket b1, Bucket b2) {
                return Order.compareKey(b2, b1);
            }
        });
        public static final Order COUNT_ASC = new InternalOrder(3, "_count", true, new Comparator<Bucket>(){

            @Override
            public int compare(Bucket b1, Bucket b2) {
                int cmp = Long.compare(b1.getDocCount(), b2.getDocCount());
                if (cmp == 0) {
                    cmp = Order.compareKey(b1, b2);
                }
                return cmp;
            }
        });
        public static final Order COUNT_DESC = new InternalOrder(4, "_count", false, new Comparator<Bucket>(){

            @Override
            public int compare(Bucket b1, Bucket b2) {
                int cmp = Long.compare(b2.getDocCount(), b1.getDocCount());
                if (cmp == 0) {
                    cmp = Order.compareKey(b1, b2);
                }
                return cmp;
            }
        });

        private static int compareKey(Bucket b1, Bucket b2) {
            if (b1 instanceof InternalHistogram.Bucket) {
                return Double.compare(((InternalHistogram.Bucket)b1).key, ((InternalHistogram.Bucket)b2).key);
            }
            if (b1 instanceof InternalDateHistogram.Bucket) {
                return Long.compare(((InternalDateHistogram.Bucket)b1).key, ((InternalDateHistogram.Bucket)b2).key);
            }
            throw new IllegalStateException("Unexpected impl: " + b1.getClass());
        }

        public static Order aggregation(String path, boolean asc) {
            return new InternalOrder.Aggregation(path, asc);
        }

        public static Order aggregation(String aggregationName, String valueName, boolean asc) {
            return new InternalOrder.Aggregation(aggregationName + "." + valueName, asc);
        }

        abstract Comparator<Bucket> comparator();
    }

    public static interface Bucket
    extends MultiBucketsAggregation.Bucket {
    }
}

