/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.SimpleValue;

public class InternalSimpleValue
extends InternalNumericMetricsAggregation.SingleValue
implements SimpleValue {
    public static final String NAME = "simple_value";
    private final double value;

    public InternalSimpleValue(String name, double value, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.format = formatter;
        this.value = value;
    }

    public InternalSimpleValue(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.value = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.value);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public double value() {
        return this.value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public InternalMax doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value) && !Double.isNaN(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.value));
        }
        return builder;
    }
}

