/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch;

import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public interface FetchSubPhase {
    default public void hitExecute(SearchContext context, HitContext hitContext) {
    }

    default public void hitsExecute(SearchContext context, SearchHit[] hits) {
    }

    public static class HitContext {
        private SearchHit hit;
        private IndexSearcher searcher;
        private LeafReaderContext readerContext;
        private int docId;
        private Map<String, Object> cache;

        public void reset(SearchHit hit, LeafReaderContext context, int docId, IndexSearcher searcher) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.searcher = searcher;
        }

        public SearchHit hit() {
            return this.hit;
        }

        public LeafReader reader() {
            return this.readerContext.reader();
        }

        public LeafReaderContext readerContext() {
            return this.readerContext;
        }

        public int docId() {
            return this.docId;
        }

        public IndexReader topLevelReader() {
            return this.searcher.getIndexReader();
        }

        public Map<String, Object> cache() {
            if (this.cache == null) {
                this.cache = new HashMap<String, Object>();
            }
            return this.cache;
        }
    }
}

