/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.SourceFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.PostingsHighlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class HighlightPhase
extends AbstractComponent
implements FetchSubPhase {
    private static final List<String> STANDARD_HIGHLIGHTERS_BY_PRECEDENCE = Arrays.asList("fvh", "postings", "plain");
    private final Map<String, Highlighter> highlighters;

    public HighlightPhase(Settings settings, Map<String, Highlighter> highlighters) {
        super(settings);
        this.highlighters = highlighters;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.highlight() == null) {
            return;
        }
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        for (SearchContextHighlight.Field field : context.highlight().fields()) {
            SourceFieldMapper sourceFieldMapper;
            Collection<String> fieldNamesToHighlight;
            if (Regex.isSimpleMatchPattern(field.field())) {
                DocumentMapper documentMapper = context.mapperService().documentMapper(hitContext.hit().type());
                fieldNamesToHighlight = documentMapper.mappers().simpleMatchToFullName(field.field());
            } else {
                fieldNamesToHighlight = Collections.singletonList(field.field());
            }
            if (context.highlight().forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper(hitContext.hit().type()).sourceMapper()).enabled()) {
                throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hitContext.hit().type() + "] has disabled _source");
            }
            boolean fieldNameContainsWildcards = field.field().contains("*");
            for (String fieldName : fieldNamesToHighlight) {
                HighlightField highlightField;
                Highlighter highlighter;
                FieldMapper fieldMapper = this.getMapperForField(fieldName, context, hitContext.hit());
                if (fieldMapper == null || fieldNameContainsWildcards && !fieldMapper.fieldType().typeName().equals("text") && !fieldMapper.fieldType().typeName().equals("keyword") && !fieldMapper.fieldType().typeName().equals("string")) continue;
                String highlighterType = field.fieldOptions().highlighterType();
                if (highlighterType == null) {
                    for (String highlighterCandidate : STANDARD_HIGHLIGHTERS_BY_PRECEDENCE) {
                        if (!this.highlighters.get(highlighterCandidate).canHighlight(fieldMapper)) continue;
                        highlighterType = highlighterCandidate;
                        break;
                    }
                    assert (highlighterType != null);
                }
                if ((highlighter = this.highlighters.get(highlighterType)) == null) {
                    throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + fieldName + "]");
                }
                Query highlightQuery = field.fieldOptions().highlightQuery();
                if (highlightQuery == null) {
                    highlightQuery = context.parsedQuery().query();
                }
                HighlighterContext highlighterContext = new HighlighterContext(fieldName, field, fieldMapper, context, hitContext, highlightQuery);
                if (!highlighter.canHighlight(fieldMapper) && fieldNameContainsWildcards || (highlightField = highlighter.highlight(highlighterContext)) == null) continue;
                highlightFields.put(highlightField.name(), highlightField);
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) {
        if (context.highlight() == null) {
            return;
        }
        for (SearchHit hit : hits) {
            for (SearchContextHighlight.Field field : context.highlight().fields()) {
                for (String fieldName : this.getFieldsToHighlight(context, field, hit)) {
                    String highlighterType;
                    Highlighter highlighter;
                    FieldMapper fieldMapper = this.getMapperForField(fieldName, context, hit);
                    if (fieldMapper == null || !((highlighter = this.getHighlighterForField(fieldMapper, highlighterType = field.fieldOptions().highlighterType())) instanceof PostingsHighlighter)) continue;
                    this.deprecationLogger.deprecated("[postings] highlighter is deprecated, please use [unified] instead", new Object[0]);
                    return;
                }
            }
        }
    }

    private Collection<String> getFieldsToHighlight(SearchContext context, SearchContextHighlight.Field field, SearchHit hit) {
        SourceFieldMapper sourceFieldMapper;
        Collection<String> fieldNamesToHighlight;
        if (Regex.isSimpleMatchPattern(field.field())) {
            DocumentMapper documentMapper = context.mapperService().documentMapper(hit.type());
            fieldNamesToHighlight = documentMapper.mappers().simpleMatchToFullName(field.field());
        } else {
            fieldNamesToHighlight = Collections.singletonList(field.field());
        }
        if (context.highlight().forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper(hit.type()).sourceMapper()).enabled()) {
            throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hit.type() + "] has disabled _source");
        }
        return fieldNamesToHighlight;
    }

    private FieldMapper getMapperForField(String fieldName, SearchContext searchContext, SearchHit hit) {
        DocumentMapper documentMapper = searchContext.mapperService().documentMapper(hit.getType());
        return documentMapper.mappers().smartNameFieldMapper(fieldName);
    }

    private Highlighter getHighlighterForField(FieldMapper fieldMapper, String name) {
        Highlighter highlighter;
        if (name == null) {
            for (String highlighterCandidate : STANDARD_HIGHLIGHTERS_BY_PRECEDENCE) {
                if (!this.highlighters.get(highlighterCandidate).canHighlight(fieldMapper)) continue;
                name = highlighterCandidate;
                break;
            }
            assert (name != null);
        }
        if ((highlighter = this.highlighters.get(name)) == null) {
            throw new IllegalArgumentException("unknown highlighter type [" + name + "] for the field [" + fieldMapper.name() + "]");
        }
        return highlighter;
    }
}

