/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.CollectionStatistics;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.MinimalMap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.IndexFieldTerm;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.LeafIndexLookup;

public class IndexField
extends MinimalMap<String, IndexFieldTerm> {
    private final Map<String, IndexFieldTerm> terms = new HashMap<String, IndexFieldTerm>();
    private final String fieldName;
    private final LeafIndexLookup indexLookup;
    private final CollectionStatistics fieldStats;

    public IndexField(String fieldName, LeafIndexLookup indexLookup) throws IOException {
        assert (fieldName != null);
        this.fieldName = fieldName;
        assert (indexLookup != null);
        this.indexLookup = indexLookup;
        this.fieldStats = this.indexLookup.getIndexSearcher().collectionStatistics(fieldName);
    }

    public long docCount() throws IOException {
        return this.fieldStats.docCount();
    }

    public long sumttf() throws IOException {
        return this.fieldStats.sumTotalTermFreq();
    }

    public long sumdf() throws IOException {
        return this.fieldStats.sumDocFreq();
    }

    public IndexFieldTerm get(Object key, int flags) {
        String termString = (String)key;
        IndexFieldTerm indexFieldTerm = this.terms.get(termString);
        if (indexFieldTerm == null) {
            indexFieldTerm = new IndexFieldTerm(termString, this.fieldName, this.indexLookup, flags);
            this.terms.put(termString, indexFieldTerm);
        }
        indexFieldTerm.validateFlags(flags);
        return indexFieldTerm;
    }

    @Override
    public IndexFieldTerm get(Object key) {
        return this.get(key, 8);
    }

    public void setDocIdInTerms(int docId) {
        for (IndexFieldTerm ti : this.terms.values()) {
            ti.setDocument(docId);
        }
    }
}

