/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks;

import java.util.concurrent.atomic.AtomicReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskId;

public abstract class CancellableTask
extends Task {
    private final AtomicReference<String> reason = new AtomicReference();

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId) {
        super(id, type, action, description, parentTaskId);
    }

    final void cancel(String reason) {
        assert (reason != null);
        this.reason.compareAndSet(null, reason);
        this.onCancelled();
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    public abstract boolean shouldCancelChildrenOnCancellation();

    public boolean isCancelled() {
        return this.reason.get() != null;
    }

    @Nullable
    public String getReasonCancelled() {
        return this.reason.get();
    }

    protected void onCancelled() {
    }
}

